/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.util;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.ide.eclipse.as.reddeer.matcher.ServerConsoleContainsNoExceptionMatcher;
import org.jboss.ide.eclipse.as.reddeer.server.editor.AbstractEditorWithBrowser;
import org.jboss.ide.eclipse.as.reddeer.server.editor.ServerModuleWebPageEditor;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServer;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerModule;
import org.jboss.ide.eclipse.as.reddeer.server.view.JBossServerView;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.WaitTimeoutExpiredException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.jboss.reddeer.eclipse.condition.ConsoleHasText;
import org.jboss.reddeer.eclipse.core.resources.AbstractExplorerItem;
import org.jboss.reddeer.eclipse.core.resources.Project;
import org.jboss.reddeer.eclipse.jdt.ui.packageexplorer.PackageExplorer;
import org.jboss.reddeer.eclipse.ui.console.ConsoleView;
import org.jboss.reddeer.eclipse.ui.dialogs.ExplorerItemPropertyDialog;
import org.jboss.reddeer.eclipse.ui.ide.NewFileCreationWizardDialog;
import org.jboss.reddeer.eclipse.ui.ide.NewFileCreationWizardPage;
import org.jboss.reddeer.eclipse.ui.problems.ProblemsView;
import org.jboss.reddeer.eclipse.ui.problems.matcher.AbstractProblemMatcher;
import org.jboss.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.jboss.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.jboss.reddeer.eclipse.wst.common.project.facet.ui.RuntimesPropertyPage;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersViewEnums;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.jboss.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.workbench.impl.editor.TextEditor;
import org.jboss.tools.as.ui.bot.itests.Activator;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.BrowserContainsTextCondition;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.ConsoleContainsTextMatcher;
import org.jboss.tools.as.ui.bot.itests.reddeer.util.EditorWithBrowserContainsTextCondition;
import org.junit.Assert;
import org.junit.Test;

public class DeployJSPProjectTemplate {
    private static final Logger log = Logger.getLogger(DeployJSPProjectTemplate.class);
    private static final String HOT_JSP_FILE_NAME = "hot.jsp";
    public static final String JSP_CONTENT = "<%@ page language=\"java\" contentType=\"text/html; charset=UTF-8\" pageEncoding=\"UTF-8\"%> \n<html> <body> Hot deployment </body> </html>";

    public void clearConsole() {
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        consoleView.clearConsole();
    }

    public void importProject(String projectName, String projectPath, String runtimeLabel) {
        log.step("Import " + projectName);
        ExternalProjectImportWizardDialog dialog = new ExternalProjectImportWizardDialog();
        dialog.open();
        WizardProjectsImportPage page = new WizardProjectsImportPage();
        page.setArchiveFile(Activator.getPathToFileWithinPlugin(projectPath));
        page.selectProjects(new String[]{projectName});
        dialog.finish();
        Project project = this.getProject(projectName);
        this.openPropertyDialog(projectName, project, runtimeLabel);
    }

    protected void openPropertyDialog(String projectName, Project project, String runtimeLabel) {
        try {
            log.step("Set targeted runtime for " + projectName);
            ExplorerItemPropertyDialog propertyDialog = new ExplorerItemPropertyDialog((AbstractExplorerItem)project);
            propertyDialog.open();
            RuntimesPropertyPage targetedRuntimes = new RuntimesPropertyPage();
            propertyDialog.select((PreferencePage)targetedRuntimes);
            targetedRuntimes.selectRuntime(runtimeLabel);
            propertyDialog.ok();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public JBossServer getServer(String name) {
        return new JBossServerView().getServer(name);
    }

    @Test
    public void deployProject(String projectName, String serverName, String expectedConsoleMessage) {
        log.step("Add " + projectName + " to the server (Add module dialog)");
        JBossServer server = this.getServer(serverName);
        this.addModule(server, projectName);
        log.step("Assert module is visible on Servers view");
        Assert.assertNotNull((String)"Server contains project", (Object)server.getModule(projectName));
        log.step("Assert console has deployment notification");
        new WaitUntil((WaitCondition)new ConsoleHasText(expectedConsoleMessage));
        this.assertNoException("Error in console after deploy");
        log.step("Open module's web page");
        JBossServerModule module = server.getModule(projectName);
        module.openWebPage();
        ServerModuleWebPageEditor editor = new ServerModuleWebPageEditor(module.getLabel().getName());
        this.assertProjectIsBuilt(projectName);
        try {
            new WaitUntil((WaitCondition)new EditorWithBrowserContainsTextCondition((AbstractEditorWithBrowser)editor, "Hello tests"));
        }
        catch (WaitTimeoutExpiredException e) {
            log.step("Deploy failed, assert project is built");
            try {
                this.assertProjectIsBuilt(projectName);
            }
            catch (Exception ee) {
                log.step("*** Refresh project");
                this.getProject(projectName).refresh();
                log.step("Re-assert project is built");
                this.assertProjectIsBuilt(projectName);
                log.step("Re-throw exception");
                throw ee;
            }
            throw e;
        }
        log.step("Assert web page text");
        MatcherAssert.assertThat((Object)editor.getText(), (Matcher)CoreMatchers.containsString((String)"Hello tests!"));
        log.step("Assert server's states");
        MatcherAssert.assertThat((Object)this.getServer(serverName).getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.STARTED));
        MatcherAssert.assertThat((Object)this.getServer(serverName).getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.SYNCHRONIZED));
        log.step("Assert no error on Problems view");
        ProblemsView problemsView = new ProblemsView();
        problemsView.open();
        MatcherAssert.assertThat((Object)problemsView.getProblems(ProblemsView.ProblemType.ERROR, new AbstractProblemMatcher[0]).size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertProjectIsBuilt(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        log.debug("Workspace root is: " + root.getLocation().toFile());
        IProject project = root.getProject(projectName);
        log.debug("Project location is: " + project.getLocation().toFile());
        IFolder buildFolder = project.getFolder("build");
        log.debug("Build folder location is: " + buildFolder.getLocation().toFile());
        log.debug("Build folder exists: " + buildFolder.exists());
        IFolder classesFolder = project.getFolder("build/classes/org");
        log.debug("Classes folder location is: " + classesFolder.getLocation().toFile());
        log.debug("Classes folder exists: " + classesFolder.exists());
        File buildFolderFilesystem = project.getFile("build").getLocation().toFile();
        log.debug("Build folder on filesystem exists: " + buildFolderFilesystem.exists());
        if (buildFolderFilesystem.exists()) {
            log.debug("Children of build folder");
            String[] stringArray = buildFolderFilesystem.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                log.debug(fileName);
                if ("classes".equals(fileName)) {
                    log.debug("Children of classes folder");
                    String[] stringArray2 = new File(buildFolderFilesystem, fileName).list();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String fileName2 = stringArray2[n4];
                        log.debug(fileName2);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        Assert.assertTrue((boolean)classesFolder.exists());
    }

    private void addModule(JBossServer server, String projectName) {
        ModifyModulesDialog modifyModulesDialog = server.addAndRemoveModules();
        ModifyModulesPage modifyModulesPage = new ModifyModulesPage();
        modifyModulesPage.add(new String[]{projectName});
        modifyModulesDialog.finish();
    }

    private Project getProject(String projectName) {
        PackageExplorer explorer = new PackageExplorer();
        explorer.open();
        return explorer.getProject(projectName);
    }

    protected void assertNoServerException(String message) {
        this.assertException(message, (Matcher<ConsoleView>)new ServerConsoleContainsNoExceptionMatcher());
    }

    protected boolean ignoreExceptionInConsole() {
        return false;
    }

    protected void assertNoException(String message) {
        this.assertException(message, (Matcher<ConsoleView>)CoreMatchers.not((Matcher)new ConsoleContainsTextMatcher("Exception")));
    }

    private void assertException(String message, Matcher<ConsoleView> consoleViewMatcher) {
        if (this.ignoreExceptionInConsole()) {
            log.step("Ignore any exception in console");
            return;
        }
        log.step("Check exception in console");
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        consoleView.toggleShowConsoleOnStandardOutChange(false);
        new WaitUntil((WaitCondition)new ConsoleHasNoChange(), TimePeriod.LONG);
        MatcherAssert.assertThat((String)message, (Object)consoleView, consoleViewMatcher);
        consoleView.close();
    }

    public void hotDeployment(String projectName) {
        log.step("Create hot.jsp file");
        NewFileCreationWizardDialog newFileDialog = new NewFileCreationWizardDialog();
        newFileDialog.open();
        NewFileCreationWizardPage page = new NewFileCreationWizardPage();
        page.setFileName(HOT_JSP_FILE_NAME);
        page.setFolderPath(new String[]{projectName, "WebContent"});
        newFileDialog.finish();
        log.step("Set content of hot.jsp file");
        TextEditor editor = new TextEditor();
        editor.setText(JSP_CONTENT);
        editor.save();
        editor.close();
        log.step("Show hot.jsp file in browser");
        BrowserContainsTextCondition bctc = new BrowserContainsTextCondition("http://localhost:8080/" + projectName + "/hot.jsp", "Hot deployment", true);
        try {
            new WaitUntil((WaitCondition)bctc, TimePeriod.LONG);
        }
        finally {
            bctc.cleanup();
        }
    }

    public void undeployProject(String serverName, String projectName, String expectedConsole) {
        log.step("Undeploy " + projectName);
        JBossServer server = this.getServer(serverName);
        this.undeploy(server, projectName);
        log.step("Assert console has undeployment notification");
        new WaitUntil((WaitCondition)new ConsoleHasText(expectedConsole));
        this.assertNoException("Error in console after undeploy");
        log.step("Assert module is not visible on Servers view");
        Assert.assertTrue((String)"Server contains no project", (boolean)server.getModules().isEmpty());
        log.step("Assert server's states");
        MatcherAssert.assertThat((Object)server.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.STARTED));
        MatcherAssert.assertThat((Object)server.getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.SYNCHRONIZED));
    }

    private void undeploy(JBossServer server, String projectName) {
        ModifyModulesDialog modifyModulesDialog = server.addAndRemoveModules();
        ModifyModulesPage modifyModulesPage = new ModifyModulesPage();
        modifyModulesPage.remove(new String[]{projectName});
        modifyModulesDialog.finish();
    }
}

