/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.reddeer.component;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.swt.api.Shell;
import org.jboss.reddeer.swt.api.Tree;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.condition.ShellIsAvailable;
import org.jboss.reddeer.swt.condition.TreeContainsItem;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.reddeer.swt.keyboard.KeyboardFactory;
import org.jboss.tools.archives.reddeer.archives.jdt.integration.LibFilesetDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ArchivePublishDialog;
import org.jboss.tools.archives.reddeer.archives.ui.EditArchiveDialog;
import org.jboss.tools.archives.reddeer.archives.ui.FilesetDialog;
import org.jboss.tools.archives.reddeer.archives.ui.NewFolderDialog;
import org.jboss.tools.archives.reddeer.archives.ui.NewJarDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.jboss.tools.archives.reddeer.component.Fileset;
import org.jboss.tools.archives.reddeer.component.Folder;
import org.jboss.tools.archives.reddeer.component.UserLibraryFileset;

public class Archive {
    private TreeItem archive;
    private TreeItem archiveProject;

    public Archive(TreeItem archiveProject, TreeItem archive) {
        this.archive = archive;
        this.archiveProject = archiveProject;
    }

    public String getName() {
        return this.archive.getText();
    }

    public NewJarDialog newJarArchive() {
        this.archive.select();
        new ContextMenu(new String[]{"New Archive", "JAR"}).select();
        return new NewJarDialog();
    }

    public NewFolderDialog newFolder() {
        this.archive.select();
        new ContextMenu(new String[]{"New Folder"}).select();
        return new NewFolderDialog();
    }

    public FilesetDialog newFileset() {
        this.archive.select();
        new ContextMenu(new String[]{"New Fileset"}).select();
        return new FilesetDialog();
    }

    public LibFilesetDialog newUserLibraryFileset() {
        this.archive.select();
        new ContextMenu(new String[]{"New User Library Fileset"}).select();
        return new LibFilesetDialog();
    }

    public void buildArchiveFull() {
        this.archive.select();
        new ContextMenu(new String[]{"Build Archive (Full)"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public EditArchiveDialog editArchive() {
        this.archive.select();
        new ContextMenu(new String[]{"Edit Archive"}).select();
        return new EditArchiveDialog();
    }

    public void deleteArchive(boolean withContextMenu) {
        this.archive.select();
        if (withContextMenu) {
            new ContextMenu(new String[]{"Delete Archive"}).select();
        } else {
            KeyboardFactory.getKeyboard().invokeKeyCombination(new int[]{127});
        }
        DefaultShell dShell = new DefaultShell("Delete selected nodes?");
        new PushButton("Yes").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)dShell));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public ArchivePublishDialog publishToServer() {
        this.archive.select();
        new ContextMenu(new String[]{"Publish To Server"}).select();
        if (new DefaultShell().getText().equals("Archive Publish Settings")) {
            return new ArchivePublishDialog();
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        return null;
    }

    public ArchivePublishDialog editPublishSettings() {
        this.archive.select();
        new ContextMenu(new String[]{"Edit publish settings..."}).select();
        return new ArchivePublishDialog();
    }

    public Archive getArchive(String archiveName) {
        new WaitUntil((WaitCondition)new TreeContainsItem(this.archive.getParent(), new String[]{this.archiveProject.getText(), this.archive.getText()}));
        return new Archive(this.archiveProject, this.archive.getItem(archiveName));
    }

    public Folder getFolder(String folderName, boolean explorer) {
        this.waitForArchiveItem(folderName, explorer);
        return new Folder(this.archive.getItem(folderName));
    }

    public Fileset getFileset(String filesetName, boolean explorer) {
        this.waitForArchiveItem(filesetName, explorer);
        return new Fileset(this.archive.getItem(filesetName));
    }

    public UserLibraryFileset getUserLibraryFileset(String userLibraryFilesetName, boolean explorer) {
        this.waitForArchiveItem(userLibraryFilesetName, explorer);
        return new UserLibraryFileset(this.archive.getItem(userLibraryFilesetName));
    }

    private void waitForArchiveItem(String item, boolean explorer) {
        if (!explorer) {
            new WaitUntil((WaitCondition)new TreeContainsItem(this.archive.getParent(), new String[]{this.archiveProject.getText(), this.archive.getText(), item}));
        } else {
            new ProjectArchivesExplorer(this.archiveProject.getText());
            new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{this.archiveProject.getText(), "Project Archives", this.archive.getText(), item}));
        }
    }
}

