/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.as.runtimes.integration.util.RuntimeMatcher;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.framework.Version;

@RunWith(value=Parameterized.class)
public class DownloadRuntimeMatcherTest
extends TestCase {
    private DownloadRuntime runtime;
    public static final String LABEL_WTP_RUNTIME = "wtp-runtime-type";
    public static final String LABEL_RUNTIME_CATEGORY = "runtime-category";
    public static final String LABEL_RUNTIME_TYPE = "runtime-type";

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[] rts = RuntimeCoreActivator.getDefault().getDownloadRuntimeArray((IProgressMonitor)new NullProgressMonitor());
        return ServerParameterUtils.asCollection(rts);
    }

    public DownloadRuntimeMatcherTest(DownloadRuntime runtime) {
        this.runtime = runtime;
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testDownloadRuntimesMatcher() {
        if (this.runtime.getProperty(LABEL_WTP_RUNTIME) == null) {
            return;
        }
        String wtpId = (String)this.runtime.getProperty(LABEL_WTP_RUNTIME);
        String category = (String)this.runtime.getProperty(LABEL_RUNTIME_CATEGORY);
        String type = (String)this.runtime.getProperty(LABEL_RUNTIME_TYPE);
        String vers = this.runtime.getVersion();
        if (!"SERVER".equals(category)) {
            return;
        }
        RuntimeMatcher m = new RuntimeMatcher();
        this.verifyContains(m, m.createPattern(wtpId, null), true);
        this.verifyContains(m, m.createPattern(String.valueOf(wtpId) + "0", null), false);
        this.verifyContains(m, m.createPattern(wtpId, type), true);
        this.verifyContains(m, m.createPattern(wtpId, String.valueOf(type) + "0"), false);
        this.verifyContains(m, m.createPattern(wtpId, type, vers, true, this.incrementMinor(vers), false), true);
        this.verifyContains(m, m.createPattern(wtpId, type, this.incrementMajor(vers), true, this.incrementMajor(vers, 2), false), false);
    }

    private void verifyContains(RuntimeMatcher m, String pattern, boolean shouldContain) {
        boolean correct;
        DownloadRuntime[] results = m.findDownloadRuntimes(pattern, (IProgressMonitor)new NullProgressMonitor());
        boolean contains = Arrays.asList(results).contains(this.runtime);
        boolean bl = correct = contains == shouldContain;
        if (!correct) {
            DownloadRuntimeMatcherTest.fail((String)("Results for pattern " + pattern + " " + (shouldContain ? "should contain" : "should not contain") + this.runtime.toString()));
        }
    }

    private String incrementMajor(String v) {
        return this.incrementMajor(v, 1);
    }

    private String incrementMinor(String v) {
        return this.incrementMinor(v, 1);
    }

    private String incrementMicro(String v) {
        return this.incrementMicro(v, 1);
    }

    private String incrementMajor(String v, int c) {
        Version vers = new Version(v);
        Version vers2 = new Version(vers.getMajor() + c, 0, 0, "Final");
        return vers2.toString();
    }

    private String incrementMinor(String v, int c) {
        Version vers = new Version(v);
        Version vers2 = new Version(vers.getMajor(), vers.getMinor() + c, 0, "Final");
        return vers2.toString();
    }

    private String incrementMicro(String v, int c) {
        Version vers = new Version(v);
        Version vers2 = new Version(vers.getMajor(), vers.getMinor(), vers.getMicro() + c, "Final");
        return vers2.toString();
    }
}

