/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.utiltests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.core.util.ServerHomeValidationUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerDetailsController;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ServerHomeValidationUtilityTest
extends TestCase {
    @Test
    public void testMockServerHomeValidator() throws CoreException {
        IStatus ret = this.internalValidation("/home/user/test", "/", true);
        ServerHomeValidationUtilityTest.assertTrue((boolean)ret.isOK());
    }

    @Test
    public void testMockServerNullHome() throws CoreException {
        IStatus ret = this.internalValidation(null, "/", true);
        ServerHomeValidationUtilityTest.assertTrue((ret.getSeverity() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testMockServerNullSep() throws CoreException {
        IStatus ret = this.internalValidation("/home/user/test", null, true);
        ServerHomeValidationUtilityTest.assertTrue((ret.getSeverity() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testMockServerDNE() throws CoreException {
        IStatus ret = this.internalValidation("/home/user/test", "/", false);
        ServerHomeValidationUtilityTest.assertTrue((ret.getSeverity() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testMockServerDeploymentOptions() throws CoreException {
        try {
            IStatus ret = this.internalValidation("/home/user/test", "/", true, true);
            ServerHomeValidationUtilityTest.fail();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private IStatus internalValidation(String home, String sep, boolean exists) throws CoreException {
        return this.internalValidation(home, sep, exists, false);
    }

    private IStatus internalValidation(String home, String sep, boolean exists, boolean loadDeploymentOptions) throws CoreException {
        IServer s = (IServer)Mockito.mock(IServer.class);
        ControllableServerBehavior delegate = (ControllableServerBehavior)Mockito.mock(ControllableServerBehavior.class);
        Mockito.when((Object)s.loadAdapter(ServerBehaviourDelegate.class, null)).thenReturn((Object)delegate);
        Mockito.when((Object)((ServerBehaviourDelegate)s.getAdapter(ServerBehaviourDelegate.class))).thenReturn((Object)delegate);
        IFilesystemController fs = (IFilesystemController)Mockito.mock(IFilesystemController.class);
        IServerDetailsController details = (IServerDetailsController)Mockito.mock(IServerDetailsController.class);
        Mockito.when((Object)delegate.getController("filesystem")).thenReturn((Object)fs);
        Mockito.when((Object)delegate.getController("serverDetails")).thenReturn((Object)details);
        Mockito.when((Object)delegate.getController("deploymentOptions")).thenThrow(new Throwable[]{new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Fail test"))});
        Mockito.when((Object)details.getProperty("PROP_SERVER_HOME")).thenReturn((Object)home);
        Mockito.when((Object)details.getProperty("SEPARATOR_CHAR")).thenReturn((Object)sep);
        RemotePath remoteHome = null;
        if (sep != null && home != null) {
            remoteHome = new RemotePath(home, sep);
        }
        Mockito.when((Object)fs.exists((IPath)Matchers.any(RemotePath.class), (IProgressMonitor)Matchers.any(IProgressMonitor.class))).thenReturn((Object)exists);
        if (loadDeploymentOptions) {
            delegate.getController("deploymentOptions");
        }
        IStatus ret = new ServerHomeValidationUtility().validateServerHome(s, false);
        return ret;
    }
}

