/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.other.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IActionType;
import org.jboss.ide.eclipse.archives.core.model.IArchiveType;
import org.jboss.ide.eclipse.archives.core.model.IExtensionManager;
import org.jboss.ide.eclipse.archives.core.model.other.internal.INodeProvider;

public class WorkspaceExtensionManager
implements IExtensionManager {
    public static final String ARCHIVE_TYPES_EXTENSION_ID = "org.jboss.ide.eclipse.archives.core.archiveTypes";
    public static final String ACTION_TYPES_EXTENSION_ID = "org.jboss.ide.eclipse.archives.core.actionTypes";
    public static final String VARIABLE_PROVIDER_EXTENSION_ID = "org.jboss.ide.eclipse.archives.core.variableProviders";
    public static final String NODE_PROVIDER_EXTENSION_ID = "org.jboss.ide.eclipse.archives.core.nodeProvider";
    private static Hashtable<String, IArchiveType> archiveTypes;
    private static Hashtable<String, IActionType> actionTypes;
    private static ArrayList<INodeProvider> nodeProviders;

    static {
        nodeProviders = null;
    }

    private IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    private void loadPackageTypes() {
        archiveTypes = new Hashtable();
        IExtension[] extensions = this.findExtension(ARCHIVE_TYPES_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object executable = elements[j].createExecutableExtension("class");
                    IArchiveType type = (IArchiveType)executable;
                    archiveTypes.put(type.getId(), type);
                }
                catch (InvalidRegistryObjectException e) {
                    ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), e);
                }
                catch (CoreException e) {
                    ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), e);
                }
                ++j;
            }
            ++i;
        }
    }

    public IArchiveType getArchiveType(String packageType) {
        if (archiveTypes == null) {
            this.loadPackageTypes();
        }
        return archiveTypes.get(packageType);
    }

    public IArchiveType[] getArchiveTypes() {
        if (archiveTypes == null) {
            this.loadPackageTypes();
        }
        Collection<IArchiveType> c = archiveTypes.values();
        return c.toArray(new IArchiveType[c.size()]);
    }

    public IActionType getActionType(String id) {
        if (actionTypes == null) {
            this.loadActionTypes();
        }
        return actionTypes.get(id);
    }

    public IActionType[] getActionTypes() {
        if (actionTypes == null) {
            this.loadActionTypes();
        }
        Collection<IArchiveType> c = archiveTypes.values();
        return c.toArray(new IActionType[c.size()]);
    }

    private void loadActionTypes() {
        actionTypes = new Hashtable();
        IExtension[] extensions = this.findExtension(ACTION_TYPES_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object executable = elements[j].createExecutableExtension("class");
                    IActionType type = (IActionType)executable;
                    actionTypes.put(type.getId(), type);
                }
                catch (InvalidRegistryObjectException e) {
                    ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), e);
                }
                catch (CoreException e) {
                    ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), e);
                }
                ++j;
            }
            ++i;
        }
    }

    public INodeProvider[] getNodeProviders() {
        if (nodeProviders == null) {
            this.loadNodeProviders();
        }
        return nodeProviders.toArray(new INodeProvider[nodeProviders.size()]);
    }

    private void loadNodeProviders() {
        nodeProviders = new ArrayList();
        IExtension[] extensions = this.findExtension(NODE_PROVIDER_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object executable = elements[j].createExecutableExtension("class");
                    INodeProvider type = (INodeProvider)executable;
                    nodeProviders.add(type);
                }
                catch (InvalidRegistryObjectException e) {
                    ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), e);
                }
                catch (CoreException e) {
                    ArchivesCore.getInstance().getLogger().log(2, e.getMessage(), e);
                }
                ++j;
            }
            ++i;
        }
    }
}

