/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.other.internal;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.VariablesPlugin;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchivesVFS;

public class WorkspaceVFS
implements IArchivesVFS,
IDynamicVariableResolver {
    private String currentProject;

    public IPath[] getWorkspaceChildren(IPath path) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null && res instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)res).members();
                IPath[] paths = new IPath[resources.length];
                int i = 0;
                while (i < resources.length) {
                    paths[i] = resources[i].getFullPath();
                    ++i;
                }
                return paths;
            }
            catch (CoreException ce) {
                return new IPath[0];
            }
        }
        return new IPath[0];
    }

    public IPath workspacePathToAbsolutePath(IPath path) {
        IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        Path append = new Path("");
        while (r == null && path.segmentCount() > 0) {
            append = new Path(path.lastSegment()).append((IPath)append);
            path = path.removeLastSegments(1);
            r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        }
        if (r != null) {
            return r.getLocation().append((IPath)append);
        }
        return null;
    }

    public String getProjectName(IPath absolutePath) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getLocation().equals((Object)absolutePath)) {
                return projects[i].getName();
            }
            ++i;
        }
        return null;
    }

    public synchronized String performStringSubstitution(String expression, String projectName, boolean reportUndefinedVariables) throws CoreException {
        if (expression == null) {
            return null;
        }
        this.currentProject = projectName;
        try {
            String string = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression, reportUndefinedVariables);
            return string;
        }
        finally {
            this.currentProject = null;
        }
    }

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        if (this == ArchivesCore.getInstance().getVFS()) {
            if (variable.getName().equals("archives_current_project")) {
                return this.currentProject;
            }
        } else {
            return ((WorkspaceVFS)ArchivesCore.getInstance().getVFS()).resolveValue(variable, argument);
        }
        return null;
    }

    public IPath[] absolutePathToWorkspacePath(IPath path) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
        IPath[] paths = new IPath[files.length];
        int i = 0;
        while (i < files.length) {
            paths[i] = files[i].getFullPath();
            ++i;
        }
        return paths;
    }
}

