/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.rse.ui.RSEDeploymentPreferenceComposite;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;

public class DeployOnlyRSEPrefComposite
extends RSEDeploymentPreferenceComposite {
    private Text deployText;
    private Button deployButton;
    private ModifyListener deployListener;

    public DeployOnlyRSEPrefComposite(Composite parent, int style, IDeploymentTypeUI.IServerModeUICallback callback) {
        super(parent, style, callback);
    }

    @Override
    protected void createRSEWidgets(Composite child) {
        this.handleDeployOnlyServer(child);
    }

    private void handleDeployOnlyServer(Composite composite) {
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.swf_DeployDirectory);
        this.deployText = new Text((Composite)this, 2048);
        this.deployText.setText(this.getServer().getDeployFolder());
        this.deployListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeployOnlyRSEPrefComposite.this.callback.execute((IUndoableOperation)new SetDeployDirCommand());
            }
        };
        this.deployText.addModifyListener(this.deployListener);
        this.deployButton = new Button((Composite)this, 8);
        this.deployButton.setText(Messages.browse);
        label.setLayoutData((Object)UIUtil.createFormData2((Object)composite, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        this.deployButton.setLayoutData((Object)UIUtil.createFormData2((Object)composite, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.deployText.setLayoutData((Object)UIUtil.createFormData2((Object)composite, (int)5, null, (int)0, (Object)label, (int)5, (Object)this.deployButton, (int)-5));
        this.deployButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String browseVal = DeployOnlyRSEPrefComposite.this.browseClicked3(DeployOnlyRSEPrefComposite.this.deployText.getShell());
                if (browseVal != null) {
                    DeployOnlyRSEPrefComposite.this.deployText.setText(browseVal);
                }
            }
        });
    }

    private void updateDeployOnlyWidgets() {
        String newDir = this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "");
        String newTemp = this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", "");
        this.deployText.removeModifyListener(this.deployListener);
        this.deployText.setText(newDir);
        this.deployText.addModifyListener(this.deployListener);
    }

    public class SetDeployDirCommand
    extends ServerCommand {
        private String oldDir;
        private String newDir;
        private Text text;
        private ModifyListener listener;

        public SetDeployDirCommand() {
            super(DeployOnlyRSEPrefComposite.this.callback.getServer(), Messages.EditorSetDeployLabel);
            this.text = DeployOnlyRSEPrefComposite.this.deployText;
            this.newDir = DeployOnlyRSEPrefComposite.this.deployText.getText();
            this.listener = DeployOnlyRSEPrefComposite.this.deployListener;
            this.oldDir = DeployOnlyRSEPrefComposite.this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "");
        }

        public void execute() {
            DeployOnlyRSEPrefComposite.this.callback.getServer().setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.newDir);
        }

        public void undo() {
            DeployOnlyRSEPrefComposite.this.callback.getServer().setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.oldDir);
            DeployOnlyRSEPrefComposite.this.updateDeployOnlyWidgets();
        }
    }
}

