/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.ports;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.editor.ports.IPortEditorExtension;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortSection;
import org.jboss.ide.eclipse.as.ui.editor.ports.SetPortCommand;

public abstract class PortEditorExtension
implements IPortEditorExtension {
    protected Text text;
    protected Label label;
    protected String labelText;
    protected String overrideValueKey;
    protected String changeValueCommandName;
    protected ServerAttributeHelper helper;
    protected Listener listener;
    protected PortSection section;
    protected int defaultValue;
    protected ControlDecoration decoration;

    public PortEditorExtension(String labelText, String overrideValueKey, int defaultValue, String changeValueCommandName) {
        this.labelText = labelText;
        this.overrideValueKey = overrideValueKey;
        this.changeValueCommandName = changeValueCommandName;
        this.defaultValue = defaultValue;
    }

    @Override
    public void setServerAttributeHelper(ServerAttributeHelper helper) {
        this.helper = helper;
    }

    @Override
    public void setSection(PortSection section) {
        this.section = section;
    }

    @Override
    public void createControl(Composite parent) {
        this.createUI(parent);
        this.initialize();
        this.addListeners();
        this.decoration = new ControlDecoration((Control)this.text, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
        this.decoration.setImage(fieldDecoration.getImage());
        this.validate();
    }

    protected void createUI(Composite parent) {
        this.label = new Label(parent, 0);
        this.text = new Text(parent, 2052);
        boolean typeHasRuntime = this.helper.getServer().getServerType().hasRuntime();
        boolean hasRuntime = this.helper.getServer().getRuntime() != null;
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).minSize(80, 10).grab(true, false).applyTo((Control)this.text);
        this.label.setText(this.labelText);
    }

    protected void initialize() {
        boolean editable = this.getEditable();
        this.text.setEnabled(editable);
        this.text.setEditable(editable);
        this.text.setText(this.helper.getAttribute(this.overrideValueKey, Integer.toString(this.defaultValue)));
    }

    protected boolean getEditable() {
        return true;
    }

    protected int discoverOffset() {
        return this.section.getPortOffset();
    }

    @Override
    public void refresh() {
        this.initialize();
    }

    protected void addListeners() {
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                PortEditorExtension.this.listenerEvent(event);
            }
        };
        this.text.addListener(24, this.listener);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text == null || e.text.equals("")) {
                    return;
                }
                try {
                    Integer n = Integer.parseInt(e.text);
                }
                catch (NumberFormatException nfe) {
                    e.doit = false;
                }
            }
        });
    }

    protected void listenerEvent(Event event) {
        this.section.execute((IUndoableOperation)this.getCommand());
    }

    public ServerCommand getCommand() {
        return new SetPortCommand(this.helper.getWorkingCopy(), this.helper, this.changeValueCommandName, this.overrideValueKey, this);
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    public void validate() {
        this.decoration.hide();
        String v = this.text.getText();
        String errorText = "The empty string is not a valid port.";
        if ("".equals(v)) {
            this.decoration.setDescriptionText(errorText);
            this.decoration.show();
        }
    }
}

