/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewRuntimeWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;

public class JBossRuntimeLocator
extends RuntimeLocatorDelegate {
    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        IRuntimeWorkingCopy wc = this.searchForRuntimes(path, monitor);
        if (wc != null) {
            listener.runtimeFound(wc);
        }
    }

    public IRuntimeWorkingCopy searchForRuntimes(IPath path, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ServerBeanLoader loader = new ServerBeanLoader(path.toFile());
        if (loader.getServerType() != JBossServerType.UNKNOWN) {
            IRuntimeWorkingCopy wc = JBossRuntimeLocator.createRuntime(path, loader);
            if (wc == null) {
                monitor.setCanceled(true);
            }
            return wc;
        }
        File[] children = path.toFile().listFiles();
        children = children == null ? new File[]{} : children;
        monitor.beginTask("Searching for JBoss runtime...", children.length);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isDirectory()) {
                    SubProgressMonitor newMon = new SubProgressMonitor(monitor, 1);
                    IRuntimeWorkingCopy wc = this.searchForRuntimes(path.append(children[i].getName()), (IProgressMonitor)newMon);
                    if (wc != null) {
                        monitor.done();
                        return wc;
                    }
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        monitor.done();
        return null;
    }

    public static IRuntimeWorkingCopy createRuntime(IPath path) {
        return JBossRuntimeLocator.createRuntime(path, new ServerBeanLoader(path.toFile()));
    }

    public static IRuntimeWorkingCopy createRuntime(IPath path, ServerBeanLoader loader) {
        String serverId = loader.getServerAdapterId();
        IServerType st = serverId == null ? null : ServerCore.findServerType((String)serverId);
        String rtId = RuntimeUtils.getRuntimeTypeId((IServerType)st);
        String append = JBossRuntimeLocator.getServerHomePathAppend(rtId);
        if (rtId != null) {
            IPath path2 = append == null ? path : path.append(append);
            try {
                IRuntimeWorkingCopy wc = JBossRuntimeLocator.createRuntimeWorkingCopy(rtId, path2.toOSString());
                return JBossRuntimeLocator.launchRuntimeWizard(wc);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getServerHomePathAppend(String runtimeType) {
        boolean b = "org.jboss.ide.eclipse.as.runtime.eap.43".equals(runtimeType) || "org.jboss.ide.eclipse.as.runtime.eap.50".equals(runtimeType);
        return b ? "jboss-as" : null;
    }

    private static IRuntimeWorkingCopy launchRuntimeWizard(final IRuntimeWorkingCopy wc) {
        final IRuntimeWorkingCopy[] wcRet = new IRuntimeWorkingCopy[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IRuntimeWorkingCopy wc2;
                wcRet[0] = wc2 = JBossRuntimeLocator.showWizard(wc);
            }
        });
        return wcRet[0];
    }

    protected static IRuntimeWorkingCopy showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        IRuntime rt;
        String title = null;
        WizardFragment fragment = null;
        TaskModel taskModel = new TaskModel();
        if (runtimeWorkingCopy == null) {
            title = Messages.wizNewRuntimeWizardTitle;
            fragment = new WizardFragment(){

                protected void createChildFragments(List<WizardFragment> list) {
                    list.add((WizardFragment)new NewRuntimeWizardFragment());
                    list.add(WizardTaskUtil.SaveRuntimeFragment);
                }
            };
        } else {
            title = Messages.wizEditRuntimeWizardTitle;
            final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment((String)runtimeWorkingCopy.getRuntimeType().getId());
            if (fragment2 == null) {
                return null;
            }
            taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
            fragment = new WizardFragment(){

                protected void createChildFragments(List<WizardFragment> list) {
                    list.add(fragment2);
                    list.add(WizardTaskUtil.SaveRuntimeFragment);
                }
            };
        }
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0 && (rt = (IRuntime)taskModel.getObject("runtime")) != null) {
            IRuntimeWorkingCopy rtwc = rt.createWorkingCopy();
            return rtwc;
        }
        return null;
    }

    private static IRuntimeWorkingCopy createRuntimeWorkingCopy(String runtimeId, String homeDir) throws CoreException {
        return JBossRuntimeLocator.createRuntimeWorkingCopy(runtimeId, homeDir, null);
    }

    @Deprecated
    public static IRuntimeWorkingCopy createRuntimeWorkingCopy(String runtimeId, String homeDir, String config) throws CoreException {
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes(null, null, (String)runtimeId);
        IRuntimeType runtimeType = runtimeTypes[0];
        IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(null, (IProgressMonitor)new NullProgressMonitor());
        runtimeWC.setLocation((IPath)new Path(homeDir));
        ((RuntimeWorkingCopy)runtimeWC).setAttribute("PROPERTY_VM_ID", JavaRuntime.getDefaultVMInstall().getId());
        ((RuntimeWorkingCopy)runtimeWC).setAttribute("PROPERTY_VM_TYPE_ID", JavaRuntime.getDefaultVMInstall().getVMInstallType().getId());
        ((RuntimeWorkingCopy)runtimeWC).setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", config);
        return runtimeWC;
    }
}

