/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.wst.server.ui.xpl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.subsystems.IExploreBehavior;
import org.jboss.ide.eclipse.as.ui.views.server.extensions.CommonActionProviderUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;

public class ExploreActionProvider
extends CommonActionProvider {
    public static final String EXPLORE = Messages.ExploreUtils_Action_Text;
    public static final String EXPLORE_DESCRIPTION = Messages.ExploreUtils_Description;
    private ICommonActionExtensionSite actionSite;
    private CommonViewer cv;
    private Action exploreAction;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        this.actionSite = aSite;
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            this.cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.createActions(this.cv, wsSite.getSelectionProvider());
        }
    }

    public void createActions(CommonViewer tableViewer, ISelectionProvider provider) {
        Shell shell = tableViewer.getTree().getShell();
        this.exploreAction = new Action(){

            public void run() {
                ExploreActionProvider.this.runExplore();
            }
        };
        this.exploreAction.setText(EXPLORE);
        this.exploreAction.setDescription(EXPLORE_DESCRIPTION);
        this.exploreAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("EXPLORE_IMAGE"));
    }

    private void runExplore() {
        this.runExplore(this.getServer(), this.getModuleServer());
    }

    private IExploreBehavior getExploreBehavior(IServer server) {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            try {
                return (IExploreBehavior)beh.getController("exploreBehavior");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void runExplore(IServer server, ModuleServer ms) {
        IExploreBehavior beh = this.getExploreBehavior(server);
        if (beh != null) {
            beh.openExplorer(server, ms == null ? null : ms.module);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IServer server = this.getServer();
        if (server != null) {
            IContributionItem menuItem;
            IExploreBehavior beh = this.getExploreBehavior(server);
            if (beh == null || !beh.canExplore(this.getServer(), this.getModuleServer() == null ? null : this.getModuleServer().module)) {
                return;
            }
            if ((this.getModuleServer() != null || this.getServer() != null) && (menuItem = CommonActionProviderUtils.getShowInQuickMenu(menu, true)) instanceof MenuManager) {
                ((MenuManager)menuItem).add((IAction)this.exploreAction);
            }
            this.exploreAction.setEnabled(true);
        }
    }

    public IServer getServer() {
        Object o = this.getSelection();
        if (o instanceof IServer) {
            return (IServer)o;
        }
        if (o instanceof ModuleServer) {
            return ((ModuleServer)o).server;
        }
        return null;
    }

    public ModuleServer getModuleServer() {
        Object o = this.getSelection();
        if (o instanceof ModuleServer) {
            return (ModuleServer)o;
        }
        return null;
    }

    protected Object getSelection() {
        ICommonViewerWorkbenchSite wsSite;
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite && (selection = (IStructuredSelection)(wsSite = (ICommonViewerWorkbenchSite)site).getSelectionProvider().getSelection()).size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }
}

