/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.tree.DomainNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.PropertyNode;
import org.jboss.tools.jmx.core.tree.Root;

public class NodeBuilder {
    public static void addToTree(Node root, ObjectName on) {
        NodeBuilder.addToTree(root, on, null);
    }

    public static void addToList(Node root, ObjectName on) {
        Node node = NodeBuilder.buildDomainNode(root, on.getDomain());
        node = NodeBuilder.buildObjectNameNode(node, "on", on.getKeyPropertyListString(), on);
    }

    public static void addToTree(Node root, ObjectName on, MBeanServerConnection mbsc) {
        Node node = NodeBuilder.buildDomainNode(root, on.getDomain());
        String keyPropertyListString = on.getKeyPropertyListString();
        String[] properties = keyPropertyListString.split(",");
        int i = 0;
        while (i < properties.length) {
            String property = properties[i];
            String key = property.substring(0, property.indexOf(61));
            String value = property.substring(property.indexOf(61) + 1, property.length());
            node = i == properties.length - 1 ? NodeBuilder.buildObjectNameNode(node, key, value, on, mbsc) : NodeBuilder.buildPropertyNode(node, key, value);
            ++i;
        }
    }

    public static Root createRoot(IConnectionWrapper connection) {
        return new Root(connection);
    }

    static Node buildDomainNode(Node parent, String domain) {
        DomainNode n = new DomainNode(parent, domain);
        if (parent != null) {
            return parent.addChild(n);
        }
        return n;
    }

    static Node buildPropertyNode(Node parent, String key, String value) {
        PropertyNode n = new PropertyNode(parent, key, value);
        if (parent != null) {
            return parent.addChild(n);
        }
        return n;
    }

    static Node buildObjectNameNode(Node parent, String key, String value, ObjectName on) {
        return NodeBuilder.buildObjectNameNode(parent, key, value, on, null);
    }

    static Node buildObjectNameNode(Node parent, String key, String value, ObjectName on, MBeanServerConnection mbsc) {
        ObjectNameNode n = new ObjectNameNode(parent, key, value, on, mbsc);
        if (n.getMbeanInfoWrapper() == null) {
            return null;
        }
        if (parent != null) {
            return parent.addChild(n);
        }
        return n;
    }
}

