/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.runtimes.integration.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ServerNamingUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerProfileInitializer;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.ide.eclipse.as.wtp.core.util.VMInstallUtil;
import org.jboss.tools.as.runtimes.integration.Messages;
import org.jboss.tools.as.runtimes.integration.ServerRuntimesIntegrationActivator;
import org.jboss.tools.as.runtimes.integration.internal.IRuntimeIntegrationConstants;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimeDetectionProblem;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class JBossASHandler
extends AbstractRuntimeDetectorDelegate
implements IRuntimeIntegrationConstants {
    private static String[] hasIncludedRuntimes = new String[]{"SOA-P", "EAP", "EPP", "EWP", "SOA-P-STD"};
    private static final String SERVER_BEAN_PROP = "SERVER_BEAN_PROP";

    static {
        Bundle bundle = Platform.getBundle((String)"org.jboss.ide.eclipse.archives.webtools");
        if (bundle != null) {
            try {
                if ((bundle.getState() & 2) == 0) {
                    bundle.start(2);
                    bundle.start(1);
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        JBossASHandler.initializeRuntimesStatic(runtimeDefinitions);
    }

    public boolean initializeRuntime(RuntimeDefinition runtimeDefinition) throws CoreException {
        return JBossASHandler.createJBossServerFromDefinitionsWithReturn(runtimeDefinition);
    }

    private static boolean initializeRuntimesStatic(List<RuntimeDefinition> runtimeDefinitions) {
        boolean created = false;
        for (RuntimeDefinition runtimeDef : runtimeDefinitions) {
            created |= JBossASHandler.createJBossServerFromDefinitionsWithReturn(runtimeDef);
        }
        return created;
    }

    @Deprecated
    public static void createJBossServerFromDefinitions(List<RuntimeDefinition> runtimeDefinitions) {
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            JBossASHandler.createJBossServerFromDefinition(runtimeDefinition);
        }
    }

    private static void createJBossServerFromDefinition(RuntimeDefinition runtimeDefinition) {
        JBossASHandler.createJBossServerFromDefinitionsWithReturn(runtimeDefinition);
    }

    private static boolean createJBossServerFromDefinitionsWithReturn(RuntimeDefinition runtimeDefinition) {
        String type;
        ServerBean sb;
        File asLocation;
        boolean created = false;
        if (runtimeDefinition.isEnabled() && (asLocation = JBossASHandler.getServerAdapterRuntimeLocation(sb = new ServerBeanLoader(runtimeDefinition.getLocation()).getServerBean(), runtimeDefinition.getLocation())) != null && asLocation.isDirectory() && JBossASHandler.serverBeanTypeExists(type = runtimeDefinition.getType())) {
            String typeId = sb.getServerAdapterTypeId();
            String name = runtimeDefinition.getName();
            String runtimeName = String.valueOf(name) + " " + RUNTIME;
            created |= JBossASHandler.createJBossServer(asLocation, typeId, name, runtimeName);
        }
        return created |= JBossASHandler.initializeRuntimesStatic(runtimeDefinition.getIncludedRuntimeDefinitions());
    }

    private static boolean serverBeanTypeExists(String type) {
        JBossServerType[] all = ServerBeanLoader.typesInOrder;
        int i = 0;
        while (i < all.length) {
            if (all[i].getId().equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean serverExistsForPath(IPath locPath) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            IRuntime runtime = servers[i].getRuntime();
            if (runtime != null && runtime.getLocation() != null && runtime.getLocation().equals((Object)locPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IRuntime findRuntimeForPath(IPath locPath) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            if (runtimes[i] != null && runtimes[i].getLocation() != null && runtimes[i].getLocation().equals((Object)locPath)) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean createJBossServer(File asLocation, String serverTypeId, String name, String runtimeName) {
        if (asLocation == null || !asLocation.isDirectory() || serverTypeId == null) {
            return false;
        }
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        if (serverType == null) {
            return false;
        }
        IRuntimeType rtType = serverType.getRuntimeType();
        if (rtType == null) {
            return false;
        }
        Path jbossAsLocationPath = new Path(asLocation.getAbsolutePath());
        if (JBossASHandler.serverExistsForPath((IPath)jbossAsLocationPath)) {
            return false;
        }
        IServer s = null;
        IRuntime runtime = JBossASHandler.findRuntimeForPath((IPath)jbossAsLocationPath);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        try {
            if (runtime == null) {
                runtime = JBossASHandler.createRuntime(runtimeName, asLocation.getAbsolutePath(), (IProgressMonitor)progressMonitor, rtType);
            }
            if (runtime != null) {
                s = JBossASHandler.createServer((IProgressMonitor)progressMonitor, runtime, serverType, name);
            }
        }
        catch (CoreException e) {
            ServerRuntimesIntegrationActivator.pluginLog().logError(Messages.JBossRuntimeStartup_Cannot_create_new_JBoss_Server, (Throwable)e);
        }
        return s != null;
    }

    private static IRuntime createRuntime(String runtimeName, String jbossASLocation, IProgressMonitor progressMonitor, IRuntimeType rtType) throws CoreException {
        runtimeName = JBossASHandler.getUniqueRuntimeName(runtimeName, rtType);
        IRuntimeWorkingCopy runtime = null;
        Path jbossAsLocationPath = new Path(jbossASLocation);
        runtime = rtType.createRuntime(null, progressMonitor);
        runtime.setLocation((IPath)jbossAsLocationPath);
        if (runtimeName != null) {
            runtime.setName(runtimeName);
        }
        return runtime.save(false, progressMonitor);
    }

    private static String getUniqueRuntimeName(String runtimeName, IRuntimeType type) {
        String name = runtimeName;
        int i = 2;
        while (JBossASHandler.getRuntime(name, type) != null) {
            name = String.valueOf(name) + " (" + i++ + ")";
        }
        return name;
    }

    private static IRuntime getRuntime(String name, IRuntimeType type) {
        if (name == null || type == null) {
            return null;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            if (runtimes[i] != null && runtimes[i].getRuntimeType() != null && name.equals(runtimes[i].getName()) && type.equals(runtimes[i].getRuntimeType())) {
                return runtimes[i];
            }
            ++i;
        }
        return null;
    }

    private static IServer createServer(IProgressMonitor progressMonitor, IRuntime runtime, IServerType serverType, String name) throws CoreException {
        if (JBossASHandler.serverWithNameExists(name)) {
            name = ServerNamingUtility.getDefaultServerName((IRuntime)runtime);
        }
        IServerWorkingCopy serverWC = serverType.createServer(null, null, (IProgressMonitor)new NullProgressMonitor());
        serverWC.setRuntime(runtime);
        if (name != null) {
            serverWC.setName(name);
        }
        IServerProfileInitializer[] initializers = ServerProfileModel.getDefault().getInitializers(serverWC.getServerType().getId(), "local");
        int i = 0;
        while (i < initializers.length) {
            initializers[i].initialize(serverWC);
            ++i;
        }
        IServer ret = serverWC.save(true, (IProgressMonitor)new NullProgressMonitor());
        ServerRuntimesIntegrationActivator.getDefault().trackNewDetectedServerEvent(serverType.getId());
        return ret;
    }

    private static boolean serverWithNameExists(String name) {
        IServer[] servers;
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (name.equals(server.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (monitor.isCanceled() || root == null) {
            return null;
        }
        ServerBeanLoader loader = new ServerBeanLoader(root);
        ServerBean serverBean = loader.getServerBean();
        if (serverBean.getBeanType() != null && Arrays.asList(JBossServerType.KNOWN_TYPES).contains(serverBean.getBeanType())) {
            RuntimeDefinition runtimeDefinition = this.createDefinition(serverBean.getName(), serverBean.getVersion(), serverBean.getUnderlyingTypeId(), new File(serverBean.getLocation()));
            this.calculateIncludedRuntimeDefinition(runtimeDefinition, monitor);
            runtimeDefinition.setProperty(SERVER_BEAN_PROP, (Object)serverBean);
            this.calculateProblems(runtimeDefinition);
            return runtimeDefinition;
        }
        return null;
    }

    public void calculateProblems(RuntimeDefinition def) {
        IExecutionEnvironment maxExecEnv;
        ServerBean sb = (ServerBean)def.getProperty(SERVER_BEAN_PROP);
        String serverType = sb.getServerAdapterTypeId();
        IServerType stt = ServerCore.findServerType((String)serverType);
        IRuntimeType rtt = stt.getRuntimeType();
        IExecutionEnvironment minExecEnv = this.getMinimumExecutionEnvironment(rtt);
        IVMInstall[] validJRE = this.getValidJREs(minExecEnv, maxExecEnv = this.getMaximumExecutionEnvironment(rtt));
        if (validJRE.length == 0) {
            String max = null;
            String min = null;
            if (minExecEnv != null && minExecEnv instanceof IExecutionEnvironment) {
                min = minExecEnv.getId();
            }
            if (maxExecEnv != null && maxExecEnv instanceof IExecutionEnvironment) {
                max = maxExecEnv.getId();
            }
            String desc = null;
            desc = min == null && max == null ? "This runtime requires a JRE be made available in the workspace, but no JRE was found." : (min == null ? "This runtime requires a JRE with maximum version " + max + " be made available in the workspace, but no such JRE was found." : (max == null ? "This runtime requires a JRE with minimum version " + min + " be made available in the workspace, but no such JRE was found." : "This runtime requires a JRE with minimum version " + min + " and maximum version " + max + " be made available in the workspace, but no such JRE was found."));
            RuntimeDetectionProblem p = this.createDetectionProblem("No valid JRE available", desc, 4, 1337);
            p.setProperty("MIN_EXEC_ENV", (Object)minExecEnv);
            p.setProperty("MAX_EXEC_ENV", (Object)maxExecEnv);
            def.setProblems(new RuntimeDetectionProblem[]{p});
        } else {
            def.setProblems(new RuntimeDetectionProblem[0]);
        }
    }

    private IVMInstall[] getValidJREs(IExecutionEnvironment minimum, IExecutionEnvironment maximum) {
        return VMInstallUtil.getValidJREs((IExecutionEnvironment)minimum, (IExecutionEnvironment)maximum);
    }

    private IExecutionEnvironment getMinimumExecutionEnvironment(IRuntimeType rtType) {
        ServerExtendedProperties sep = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties((Object)rtType);
        if (sep instanceof JBossExtendedProperties) {
            return ((JBossExtendedProperties)sep).getMinimumExecutionEnvironment();
        }
        return null;
    }

    private IExecutionEnvironment getMaximumExecutionEnvironment(IRuntimeType rtType) {
        ServerExtendedProperties sep = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties((Object)rtType);
        if (sep instanceof JBossExtendedProperties) {
            return ((JBossExtendedProperties)sep).getMaximumExecutionEnvironment();
        }
        return null;
    }

    private void calculateIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition, IProgressMonitor monitor) {
        if (runtimeDefinition == null || runtimeDefinition.getType() == null || !this.hasIncludedRuntimes(runtimeDefinition.getType())) {
            return;
        }
        this.loadIncludedDefinitions(runtimeDefinition);
    }

    private boolean hasIncludedRuntimes(String type) {
        return Arrays.asList(hasIncludedRuntimes).contains(type);
    }

    private String getLocationForRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
        File location;
        String path = null;
        if (runtimeDefinition != null && runtimeDefinition.getLocation() != null && (location = JBossASHandler.getServerAdapterRuntimeLocation(runtimeDefinition)) != null && location.isDirectory()) {
            try {
                path = location.getCanonicalPath();
            }
            catch (IOException e) {
                ServerRuntimesIntegrationActivator.pluginLog().logError((Throwable)e);
                path = location.getAbsolutePath();
            }
        }
        return path;
    }

    private static File getServerAdapterRuntimeLocation(RuntimeDefinition runtimeDefinitions) {
        ServerBeanLoader loader = new ServerBeanLoader(runtimeDefinitions.getLocation());
        return JBossASHandler.getServerAdapterRuntimeLocation(loader.getServerBean(), runtimeDefinitions.getLocation());
    }

    private static File getServerAdapterRuntimeLocation(ServerBean sb, File root) {
        String version = sb.getVersion();
        String relative = sb.getBeanType().getRootToAdapterRelativePath(version);
        if (relative == null) {
            return root;
        }
        return new File(root, relative);
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        String path = this.getLocationForRuntimeDefinition(runtimeDefinition);
        if (path != null) {
            IServer[] servers = ServerCore.getServers();
            int i = 0;
            while (i < servers.length) {
                IRuntime runtime = servers[i].getRuntime();
                if (runtime != null && runtime.getLocation() != null) {
                    String loc = runtime.getLocation().toOSString();
                    try {
                        loc = new File(loc).getCanonicalPath();
                    }
                    catch (IOException e) {
                        ServerRuntimesIntegrationActivator.pluginLog().logError((Throwable)e);
                    }
                    if (path.equals(loc)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public void computeIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
    }

    public String getVersion(RuntimeDefinition runtimeDefinition) {
        return runtimeDefinition.getVersion();
    }
}

