/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.dependency;

import java.io.File;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;

@Mojo(name="copy-dependencies", requiresProject=true)
public class CopyDependenciesMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/dependencies")
    private File outputDir;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TychoProject tychoProject = this.projectTypes.get(this.project.getPackaging());
        if (tychoProject == null) {
            throw new MojoExecutionException("This only applies to Tycho projects");
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        final StringBuilder errorBuilder = new StringBuilder();
        tychoProject.getDependencyWalker(DefaultReactorProject.adapt((MavenProject)this.project)).walk(new ArtifactDependencyVisitor(){

            public void visitPlugin(PluginDescription pluginRef) {
                try {
                    File location = pluginRef.getLocation(true);
                    if (location.isFile()) {
                        FileUtils.copyFileToDirectory((File)pluginRef.getLocation(true), (File)CopyDependenciesMojo.this.outputDir);
                    } else if (location.isDirectory()) {
                        if (pluginRef.getMavenProject() != null) {
                            CopyDependenciesMojo.this.getLog().warn((CharSequence)("Reactor projects not yet supported: " + pluginRef.getMavenProject()));
                        } else {
                            CopyDependenciesMojo.this.getLog().warn((CharSequence)("Directory-shaped bundles not yet supported: " + pluginRef.getLocation(true)));
                        }
                    }
                }
                catch (Exception ex) {
                    errorBuilder.append("Couldn't copy " + pluginRef.getLocation(true) + " to " + CopyDependenciesMojo.this.outputDir);
                    errorBuilder.append("\n");
                }
            }
        });
        if (errorBuilder.length() > 0) {
            throw new MojoFailureException(errorBuilder.toString());
        }
    }
}

