/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.mc;

import java.net.URL;
import java.util.Map;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.unit.mc.TestCaseFactory;
import org.jboss.unit.mc.api.annotations.Bootstrap;
import org.jboss.unit.spi.pojo.TestCase;
import org.jboss.unit.spi.pojo.TestCaseLifeCycleException;
import org.jboss.unit.spi.pojo.TestLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCTestLifeCycle
extends BasicBootstrap
implements TestLifeCycle {
    private TestLifeCycle delegate;
    private BeanXMLDeployer beanDeployer;
    private KernelDeployment deployment;

    public MCTestLifeCycle(TestLifeCycle delegate) {
        this.delegate = delegate;
    }

    public TestCase newTestCase(String name) throws TestCaseLifeCycleException {
        return this.delegate.newTestCase(name);
    }

    public void testCaseParametrize(TestCase testCase, Map<String, String> parametrization) throws TestCaseLifeCycleException {
        this.delegate.testCaseParametrize(testCase, parametrization);
    }

    public void testCaseCreate(TestCase testCase) throws TestCaseLifeCycleException {
        Class<?> testClass = testCase.getPOJO().getClass();
        Bootstrap bootstrapAnnotation = testClass.getAnnotation(Bootstrap.class);
        if (bootstrapAnnotation == null) {
            throw new TestCaseLifeCycleException("No Bootstrap annotation found");
        }
        URL url = testClass.getResource(bootstrapAnnotation.resourceName());
        if (url == null) {
            throw new TestCaseLifeCycleException("No URL found for bean xml " + bootstrapAnnotation.resourceName());
        }
        this.run();
        try {
            String beanName = bootstrapAnnotation.beanName();
            AbstractBeanMetaData bmd = new AbstractBeanMetaData(beanName, testClass.getName());
            AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
            bmd.setConstructor((ConstructorMetaData)cmd);
            TestCaseFactory factory = new TestCaseFactory(testCase.getPOJO());
            AbstractValueMetaData vmd = new AbstractValueMetaData((Object)factory);
            cmd.setFactory((ValueMetaData)vmd);
            cmd.setFactoryMethod("getTestCase");
            this.getKernel().getController().install((BeanMetaData)bmd);
        }
        catch (Throwable throwable) {
            if (this.deployment != null) {
                if (throwable instanceof IllegalStateException) {
                    for (KernelControllerContext kernelControllerContext : this.deployment.getInstalledContexts()) {
                        Throwable t = kernelControllerContext.getError();
                        if (t == null) continue;
                        throwable = t;
                        break;
                    }
                }
                if (this.deployment != null) {
                    this.beanDeployer.undeploy(this.deployment);
                }
            }
            throw new TestCaseLifeCycleException(throwable);
        }
        try {
            this.beanDeployer = new BeanXMLDeployer(this.getKernel());
            this.deployment = this.beanDeployer.deploy(url);
            this.beanDeployer.validate(this.deployment);
        }
        catch (Throwable throwable) {
            throw new TestCaseLifeCycleException(throwable);
        }
        this.delegate.testCaseCreate(testCase);
    }

    public void testCaseInvoke(TestCase testCase) throws TestCaseLifeCycleException {
        this.delegate.testCaseInvoke(testCase);
    }

    public void testCaseDestroy(TestCase testCase) {
        try {
            this.delegate.testCaseDestroy(testCase);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (this.deployment != null) {
            this.beanDeployer.undeploy(this.deployment);
        }
    }
}

