/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.remote.driver;

import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class RemoteDriverCommandContext
{

   /** The previous response if not null. */
   private RemoteDriverResponseContext responseContext;

   /** . */
   private final int requestCount;

   /** The command to invoke. */
   private DriverCommand command;

   /** . */
   private final Map<String, Serializable> payload;

   public RemoteDriverCommandContext(RemoteDriverResponseContext responseContext, DriverCommand command)
   {
      this.responseContext = responseContext;
      this.requestCount = responseContext.getCommandContext().requestCount + 1;
      this.command = command;
      this.payload = new HashMap<String, Serializable>(responseContext.getPayload());
   }

   public RemoteDriverCommandContext(DriverCommand command)
   {
      this.responseContext = null;
      this.requestCount = -1;
      this.command = command;
      this.payload = new HashMap<String, Serializable>();
   }

   public RemoteDriverCommandContext(RemoteDriverCommandContext commandContext, DriverCommand command)
   {
      Map<String, Serializable> payload = commandContext.responseContext != null ? new HashMap<String, Serializable>(commandContext.responseContext.getPayload()) : new HashMap<String, Serializable>();

      //
      this.responseContext = commandContext.responseContext;
      this.requestCount = commandContext.requestCount + 1;
      this.command = command;
      this.payload = payload;
   }

   public RemoteDriverCommandContext(RemoteDriverCommandContext commandContext)
   {
      Map<String, Serializable> payload = commandContext.responseContext != null ? new HashMap<String, Serializable>(commandContext.responseContext.getPayload()) : new HashMap<String, Serializable>();

      //
      this.responseContext = commandContext.responseContext;
      this.requestCount = commandContext.requestCount + 1;
      this.command = commandContext.command;
      this.payload = payload;
   }

   public Map<String, Serializable> getPayload()
   {
      return payload;
   }

   public int getRequestCount()
   {
      return requestCount;
   }

   public RemoteDriverResponseContext createResponseContext(DriverResponse response)
   {
      return new RemoteDriverResponseContext(this, response);
   }

   public RemoteDriverResponseContext getResponseContext()
   {
      return responseContext;
   }

   public DriverCommand getCommand()
   {
      return command;
   }
}
