/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.remote.driver.webpage;

import java.io.Serializable;

/**
 * @author <a href="mailto:sshah@redhat.com">Sohil Shah</a>
 *
 */
public class WebPageData implements Serializable
{
   private String alert = null;
   private String[] buttons = null;
   private String[] fields = null;
   private String[] links = null;
   private String[] windowIds = null;
   private String[] windowNames = null;
   private String[] windowTitles = null;
   private String bodyText = null;
   private String confirmation = null;
   private String cookie = null;
   private String htmlSource = null;
   private String location = null;
   private String prompt = null;
   
   public String getAlert()
   {
      return alert;
   }
   
   public void setAlert(String alert)
   {
      this.alert = alert;
   }
   
   public String getBodyText()
   {
      return bodyText;
   }
   
   public void setBodyText(String bodyText)
   {
      this.bodyText = bodyText;
   }
   
   public String[] getButtons()
   {
      return buttons;
   }
   
   public void setButtons(String[] buttons)
   {
      this.buttons = buttons;
   }
   
   public String getConfirmation()
   {
      return confirmation;
   }
   
   public void setConfirmation(String confirmation)
   {
      this.confirmation = confirmation;
   }
   
   public String getCookie()
   {
      return cookie;
   }
   
   public void setCookie(String cookie)
   {
      this.cookie = cookie;
   }
   
   public String[] getFields()
   {
      return fields;
   }
   
   public void setFields(String[] fields)
   {
      this.fields = fields;
   }
   
   public String getPrompt()
   {
      return prompt;
   }
   
   public void setPrompt(String prompt)
   {
      this.prompt = prompt;
   }
   
   public String getHtmlSource()
   {
      return htmlSource;
   }
   
   public void setHtmlSource(String htmlSource)
   {
      this.htmlSource = htmlSource;
   }
   
   public String[] getLinks()
   {
      return links;
   }
   
   public void setLinks(String[] links)
   {
      this.links = links;
   }
   
   public String getLocation()
   {
      return location;
   }
   
   public void setLocation(String location)
   {
      this.location = location;
   }
   
   public String[] getWindowIds()
   {
      return windowIds;
   }
   
   public void setWindowIds(String[] windowIds)
   {
      this.windowIds = windowIds;
   }
   
   public String[] getWindowNames()
   {
      return windowNames;
   }
   
   public void setWindowNames(String[] windowNames)
   {
      this.windowNames = windowNames;
   }
   
   public String[] getWindowTitles()
   {
      return windowTitles;
   }
   
   public void setWindowTitles(String[] windowTitles)
   {
      this.windowTitles = windowTitles;
   }   
}
