/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.unit.tooling.ant;

import org.apache.tools.ant.Task;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.XMLResultAggregator;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Environment;
import org.jboss.unit.tooling.ant.configuration.ReportsType;
import org.jboss.unit.tooling.ant.configuration.ParameterType;

import java.util.List;
import java.util.LinkedList;
import java.util.Set;
import java.util.HashSet;

/**
 * @author <a href="mailto:boleslaw dot dawidowicz at redhat anotherdot com">Boleslaw Dawidowicz</a>
 * @version $Revision: 0.1 $
 */
public class JBossUnitTask extends Task
{
   public static final String MAVEN_SKIP_TEST = "maven.test.skip";

   List<TestsType> testsTypes = new LinkedList();

   private ReportsType reports;

   private Path path;

   private boolean jpda;

   private String jpdaPort = "9000";

   private boolean jpdaSuspend = true;

   private boolean useJUL = true;

   private boolean assertions = true;

   private boolean failOnError = false;

   private Set<Environment.Variable> sysproperties = new HashSet<Environment.Variable>();

   private Set<ParameterType> parameters = new HashSet<ParameterType>();

   public JBossUnitTask()
   {
   }

   public void addConfiguredTests(TestsType tests)
   {
      tests.setProject(getProject());
      tests.setParent(this);
      testsTypes.add(tests);
   }

   public void addConfiguredClasspath(Path path)
   {
      System.out.println("Adding path: " + path.toString());
      this.path = path;
   }

   public void addConfiguredReports(ReportsType reports)
   {
      this.reports = reports;
   }

   public void addConfiguredParameter(ParameterType param)
   {
      this.parameters.add(param);
   }


   public void execute() throws BuildException
   {

      String testSkip = (String)getProject().getProperties().get(MAVEN_SKIP_TEST);

      // Skip tests
      if (testSkip != null && testSkip.equalsIgnoreCase("true"))
      {
         //TODO: make it logging

         System.out.println("Skipping test execution: " + MAVEN_SKIP_TEST + " set to true");

         return;
      }

      for (TestsType testsType : testsTypes)
      {

         // Update reports
         if (testsType.getReports() == null && getReports() != null)
         {
            testsType.setReports(getReports());   
         }

         // Local classpath for tests overide the global one
         if (testsType.getClasspath() == null && path != null)
         {
            testsType.addConfiguredClasspath(path);
         }


         // Merge system properties
         Set<Environment.Variable> propCopy = new HashSet<Environment.Variable>();
         propCopy.addAll(sysproperties);
         propCopy.addAll(testsType.getSysproperties());
         testsType.setSysproperties(propCopy);

         // Merge runtime parameters
         Set<ParameterType> paramCopy = new HashSet<ParameterType>();
         paramCopy.addAll(parameters);
         paramCopy.addAll(testsType.getParameters());
         testsType.setParameters(paramCopy);

         testsType.execute();


      }

   }

   public void addConfiguredSysproperty(Environment.Variable variable)
   {
      sysproperties.add(variable);
   }


   public ReportsType getReports()
   {
      return reports;
   }

   public void setReports(ReportsType reports)
   {
      this.reports = reports;
   }

   public boolean isJpda()
   {
      return jpda;
   }

   public void setJpda(boolean jpda)
   {
      this.jpda = jpda;
   }

   public String getJpdaPort()
   {
      return jpdaPort;
   }

   public void setJpdaPort(String jpdaPort)
   {
      this.jpdaPort = jpdaPort;
   }

   public boolean isJpdaSuspend()
   {
      return jpdaSuspend;
   }

   public void setJpdaSuspend(boolean jpdaSuspend)
   {
      this.jpdaSuspend = jpdaSuspend;
   }

   public boolean isUseJUL()
   {
      return useJUL;
   }

   public void setUseJUL(boolean useJUL)
   {
      this.useJUL = useJUL;
   }

   public boolean isAssertions()
   {
      return assertions;
   }

   public void setAssertions(boolean assertions)
   {
      this.assertions = assertions;
   }

   public boolean isFailOnError()
   {
      return failOnError;
   }

   public void setFailOnError(boolean failOnError)
   {
      this.failOnError = failOnError;
   }
}
