/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling.ant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.jboss.unit.tooling.JavaBuilder;
import org.jboss.unit.tooling.TaskExecutingThread;
import org.jboss.unit.tooling.ant.JBossUnitTask;
import org.jboss.unit.tooling.ant.configuration.ExcludeType;
import org.jboss.unit.tooling.ant.configuration.IncludeType;
import org.jboss.unit.tooling.ant.configuration.ParameterType;
import org.jboss.unit.tooling.ant.configuration.PropertyType;
import org.jboss.unit.tooling.ant.configuration.ReportsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestsType {
    private String config;
    private boolean fork = true;
    private List<IncludeType> includes = new LinkedList<IncludeType>();
    private List<ExcludeType> excludes = new LinkedList<ExcludeType>();
    private ReportsType reports;
    private Project project;
    private Path path;
    private String suiteName;
    private List<PropertyType> properties = new ArrayList<PropertyType>();
    private Set<Environment.Variable> sysproperties = new HashSet<Environment.Variable>();
    private Set<ParameterType> parameters = new HashSet<ParameterType>();
    private JBossUnitTask jbossUnitTask;

    public void execute() throws BuildException {
        Java javaTask = this.createJava();
        try {
            System.out.println("Invoking java: " + javaTask.getCommandLine().toString());
            TaskExecutingThread executor = new TaskExecutingThread((Task)javaTask);
            executor.run();
        }
        catch (Exception e) {
            throw new BuildException("Testsuite executed with test failures");
        }
    }

    private Java createJava() {
        Java javaTask = null;
        try {
            JavaBuilder javaBuilder = new JavaBuilder(this.getProject());
            this.addArguments(javaBuilder);
            javaBuilder.applyVariables((Map)this.getProject().getProperties());
            javaTask = javaBuilder.buildJava();
            if (this.getClasspath() != null) {
                Path javaPath = javaTask.createClasspath();
                javaPath.add(this.getClasspath());
            }
            for (Environment.Variable sysproperty : this.sysproperties) {
                javaTask.addSysproperty(sysproperty);
            }
        }
        catch (BuildException e) {
            throw new IllegalStateException("Failed to create <java> ant task: ", e);
        }
        return javaTask;
    }

    private void addArguments(JavaBuilder javaBuilder) {
        javaBuilder.setConfig(this.config);
        javaBuilder.setJPDA(this.jbossUnitTask.isJpda());
        javaBuilder.setJPDAport(Integer.decode(this.jbossUnitTask.getJpdaPort()).intValue());
        javaBuilder.setSuspend(this.jbossUnitTask.isJpdaSuspend());
        javaBuilder.setUseJUL(this.jbossUnitTask.isUseJUL());
        javaBuilder.setAssertions(this.jbossUnitTask.isAssertions());
        javaBuilder.setFork(this.isFork());
        javaBuilder.setFailOnError(this.jbossUnitTask.isFailOnError());
        if (this.getSuiteName() != null) {
            javaBuilder.setSuiteName(this.getSuiteName());
        }
        if (this.getReports() != null && this.getReports().getXMLReports() != null) {
            javaBuilder.setXmlReportDir(this.getReports().getXMLReports().getToDir());
        }
        if (this.getReports() != null && this.getReports().getHTMLReports() != null) {
            javaBuilder.setHtmlReportDir(this.getReports().getHTMLReports().getToDir());
        }
        for (IncludeType include : this.includes) {
            if (include.getId() != null && (include.getIds() != null || include.getKeywords() != null)) {
                throw new IllegalStateException("The use of attribute 'id' in <include> tag should be exclusive");
            }
            if (include.getIds() != null) {
                javaBuilder.addUnparsedIncludeIDs(include.getIds());
            }
            if (include.getKeywords() != null) {
                javaBuilder.addUnparsedIncludeKeywords(include.getKeywords());
            }
            if (include.getId() == null) continue;
            javaBuilder.addUnparsedIncludeIDs(include.getId());
        }
        for (ExcludeType exclude : this.excludes) {
            if (exclude.getId() != null && (exclude.getIds() != null || exclude.getKeywords() != null)) {
                throw new IllegalStateException("The use of attribute 'id' in <exclude> tag should be exclusive");
            }
            if (exclude.getIds() != null) {
                javaBuilder.addUnparsedExcludeIDs(exclude.getIds());
            }
            if (exclude.getKeywords() != null) {
                javaBuilder.addUnparsedExcludeKeywords(exclude.getKeywords());
            }
            if (exclude.getId() == null) continue;
            javaBuilder.addUnparsedExcludeIDs(exclude.getId());
        }
        if (this.properties.size() > 0) {
            for (PropertyType property : this.properties) {
                javaBuilder.addProperty(property.getName(), property.getValue());
            }
            javaBuilder.updateFQNProperties((Map)this.getProject().getProperties());
        }
        for (ParameterType parameter : this.parameters) {
            javaBuilder.addParameter(parameter.getName(), parameter.getValues());
        }
        javaBuilder.updateFQNParameters((Map)this.getProject().getProperties());
    }

    public Set<Environment.Variable> getSysproperties() {
        return this.sysproperties;
    }

    public void setSysproperties(Set<Environment.Variable> sysproperties) {
        this.sysproperties = sysproperties;
    }

    public void addConfiguredInclude(IncludeType include) {
        this.includes.add(include);
    }

    public void addConfiguredExclude(ExcludeType exclude) {
        this.excludes.add(exclude);
    }

    public void addConfiguredReports(ReportsType reports) {
        this.reports = reports;
    }

    public void addConfiguredProperty(PropertyType property) {
        this.properties.add(property);
    }

    public void addConfiguredParameter(ParameterType param) {
        this.parameters.add(param);
    }

    public Set<ParameterType> getParameters() {
        return this.parameters;
    }

    public void setParameters(Set<ParameterType> parameters) {
        this.parameters = parameters;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Path getClasspath() {
        return this.path;
    }

    public void addConfiguredClasspath(Path path) {
        this.path = path;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public ReportsType getReports() {
        return this.reports;
    }

    public void setReports(ReportsType reports) {
        this.reports = reports;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public JBossUnitTask getParent() {
        return this.jbossUnitTask;
    }

    public void setParent(JBossUnitTask jbossUnitTask) {
        this.jbossUnitTask = jbossUnitTask;
    }
}

