/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling.maven2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.jboss.unit.tooling.JavaBuilder;
import org.jboss.unit.tooling.TaskExecutingThread;
import org.jboss.unit.tooling.TestFailedException;
import org.jboss.unit.tooling.maven2.UnitMojo;
import org.jboss.unit.tooling.maven2.configuration.CasesDescription;
import org.jboss.unit.tooling.maven2.configuration.Parameter;
import org.jboss.unit.tooling.maven2.configuration.Reports;
import org.jboss.unit.tooling.maven2.configuration.Testsuite;

public class TestSuiteExecutor {
    private final MavenProject project;
    private final Testsuite testsuite;
    private final UnitMojo unitMojo;

    private TestSuiteExecutor() {
        this.project = null;
        this.testsuite = null;
        this.unitMojo = null;
    }

    public TestSuiteExecutor(MavenProject project, Testsuite testsuite, UnitMojo unitMojo) {
        this.project = project;
        this.testsuite = testsuite;
        this.unitMojo = unitMojo;
    }

    public void execute() throws Exception {
        String line;
        BufferedReader br;
        Java javaTask = this.createJavaTask();
        System.out.println("Invoking java: " + javaTask.getCommandLine().toString());
        File log = null;
        javaTask.setAppend(true);
        javaTask.setLogError(true);
        try {
            log = File.createTempFile("jboss-unit-" + System.currentTimeMillis(), "log");
            javaTask.setOutput(log);
            javaTask.setError(log);
            TaskExecutingThread executor = new TaskExecutingThread((Task)javaTask);
            executor.run();
            br = new BufferedReader(new FileReader(log));
            line = null;
        }
        catch (Exception e) {
            try {
                throw new TestFailedException("Testsuite executed with test failures");
            }
            catch (Throwable throwable) {
                BufferedReader br2 = new BufferedReader(new FileReader(log));
                String line2 = null;
                while ((line2 = br2.readLine()) != null) {
                    System.out.println(line2);
                }
                log.delete();
                throw throwable;
            }
        }
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        log.delete();
    }

    private Java createJavaTask() {
        Java javaTask = null;
        try {
            JavaBuilder javaBuilder = new JavaBuilder();
            this.addArguments(javaBuilder);
            javaBuilder.applyVariables((Map)System.getProperties());
            javaTask = javaBuilder.buildJava();
            Path path = javaTask.createClasspath();
            try {
                for (String element : this.project.getTestClasspathElements()) {
                    path.createPathElement().setLocation(new File(element));
                }
            }
            catch (DependencyResolutionRequiredException e) {
                e.printStackTrace();
            }
        }
        catch (BuildException e) {
            throw new IllegalStateException("Failed to create <java> ant task: ", e);
        }
        return javaTask;
    }

    private void addArguments(JavaBuilder javaBuilder) {
        javaBuilder.setConfig(this.testsuite.getConfig());
        Reports reports = this.testsuite.getReports();
        if (reports != null && reports.getXml() != null) {
            javaBuilder.setXmlReportDir(reports.getXml());
        }
        if (reports != null && reports.getHtml() != null) {
            javaBuilder.setHtmlReportDir(reports.getHtml());
        }
        if (this.unitMojo.isJpda()) {
            javaBuilder.setJPDA(true);
        }
        if (this.unitMojo.getJpdaPort() != null) {
            javaBuilder.setJPDAport(Integer.decode(this.unitMojo.getJpdaPort()).intValue());
        }
        javaBuilder.setSuspend(Boolean.parseBoolean(this.unitMojo.getJpdaSuspend()));
        javaBuilder.setUseJUL(this.unitMojo.isUseJUL());
        javaBuilder.setAssertions(this.unitMojo.isAssertions());
        javaBuilder.setFailOnError(this.unitMojo.isFailOnError());
        javaBuilder.setFork(this.unitMojo.isFork());
        for (CasesDescription include : this.testsuite.getIncludes()) {
            if (include.getIds() != null) {
                for (String id : include.getIds()) {
                    javaBuilder.addIncludeID(id);
                }
            }
            if (include.getKeywords() == null) continue;
            for (String keyword : include.getKeywords()) {
                javaBuilder.addIncludeKeyword(keyword);
            }
        }
        for (CasesDescription exclude : this.testsuite.getExcludes()) {
            if (exclude.getIds() != null) {
                for (String id : exclude.getIds()) {
                    javaBuilder.addExcludeID(id);
                }
            }
            if (exclude.getKeywords() == null) continue;
            for (String keyword : exclude.getKeywords()) {
                javaBuilder.addExcludeKeyword(keyword);
            }
        }
        if (this.testsuite.getProperties().size() > 0) {
            for (Object propertyName : this.testsuite.getProperties().keySet()) {
                javaBuilder.addProperty(propertyName.toString(), this.testsuite.getProperties().get(propertyName).toString());
            }
            javaBuilder.updateFQNProperties((Map)System.getProperties());
        }
        for (Parameter parameter : this.testsuite.getParameters()) {
            javaBuilder.addParameter(parameter.getName(), Arrays.asList(parameter.getValues()));
        }
        javaBuilder.updateFQNParameters((Map)System.getProperties());
    }
}

