/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling.maven2;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jboss.unit.tooling.maven2.TestSuiteExecutor;
import org.jboss.unit.tooling.maven2.configuration.Reports;
import org.jboss.unit.tooling.maven2.configuration.Testsuite;

public class UnitMojo
extends AbstractMojo {
    public static final String MAVEN_SKIP_TEST = "maven.test.skip";
    private Testsuite[] testsuites;
    private Reports reports;
    private boolean jpda;
    private String jpdaPort;
    private String jpdaSuspend = "true";
    private boolean useJUL = true;
    private boolean fork = true;
    private boolean assertions = true;
    private boolean failOnError = false;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        String testSkip = (String)System.getProperties().get(MAVEN_SKIP_TEST);
        if (testSkip != null && testSkip.equalsIgnoreCase("true")) {
            System.out.println("Skipping test execution: maven.test.skip set to true");
            return;
        }
        for (Testsuite testsuite : this.testsuites) {
            if (testsuite.getReports() == null && this.reports != null) {
                testsuite.setReports(this.reports);
            }
            TestSuiteExecutor executor = new TestSuiteExecutor(this.project, testsuite, this);
            try {
                executor.execute();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Build failed", e);
            }
        }
    }

    public boolean isJpda() {
        return this.jpda;
    }

    public String getJpdaPort() {
        return this.jpdaPort;
    }

    public String getJpdaSuspend() {
        return this.jpdaSuspend;
    }

    public boolean isUseJUL() {
        return this.useJUL;
    }

    public void setUseJUL(boolean useJUL) {
        this.useJUL = useJUL;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean isAssertions() {
        return this.assertions;
    }

    public void setAssertions(boolean assertions) {
        this.assertions = assertions;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

