/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.impl.generic.agent;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.Deployer;
import org.jboss.logging.Logger;
import org.jboss.portal.test.framework.agent.TestAgent;
import org.jboss.portal.test.framework.impl.generic.config.AuthenticationConfig;
import org.jboss.portal.test.framework.impl.generic.config.DeployerConfig;
import org.jboss.portal.test.framework.impl.generic.server.GenericServiceLookup;
import org.jboss.portal.test.framework.server.ServiceLookupFailedException;

public class GenericTestAgent
extends GenericServiceLookup
implements TestAgent {
    private static Logger log = Logger.getLogger(GenericTestAgent.class);
    private Deployer cargoDeployer;
    private DeployerConfig deployerConfig;
    private AuthenticationConfig authenticationConfig;

    public DeployerConfig getDeployerConfig() {
        return this.deployerConfig;
    }

    public void setDeployerConfig(DeployerConfig deployerConfig) {
        this.deployerConfig = deployerConfig;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public void setAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    public void start() {
        Configuration cfg = this.deployerConfig.createConfiguration();
        if (this.authenticationConfig != null) {
            cfg.setProperty("cargo.remote.username", this.authenticationConfig.getUsername());
            cfg.setProperty("cargo.remote.password", this.authenticationConfig.getPassword());
        }
        Container container = this.deployerConfig.createContainer(cfg);
        this.cargoDeployer = this.deployerConfig.createDeployer(container);
    }

    public void deploy(URL url) throws Exception {
        Deployable deployable = this.createDeployable(url);
        log.debug((Object)("Going to deploy " + url));
        this.cargoDeployer.deploy(deployable);
        log.debug((Object)("Deployed " + url));
    }

    public void undeploy(URL url) throws Exception {
        Deployable deployable = this.createDeployable(url);
        log.debug((Object)("Going to undeploy " + url));
        this.cargoDeployer.undeploy(deployable);
        log.debug((Object)("Undeployed " + url));
    }

    private Deployable createDeployable(URL url) throws URISyntaxException, IllegalArgumentException {
        File f;
        if (url != null && "file".equals(url.getProtocol()) && (f = new File(url.getFile())).getName().endsWith(".war")) {
            return new WAR(f.getAbsolutePath());
        }
        throw new IllegalArgumentException("Illegal URL " + url);
    }

    public Object lookupService() throws ServiceLookupFailedException {
        return this;
    }
}

