/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

public class IOTools {
    private static final Logger log = Logger.getLogger(IOTools.class);
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_PARAMETER_TYPES = new Class[0];

    public static void safeClose(Object closable) {
        if (closable != null) {
            try {
                Method m = closable.getClass().getMethod("close", EMPTY_PARAMETER_TYPES);
                if (Modifier.isStatic(m.getModifiers())) {
                    log.warn((Object)"close() method on closable object is static");
                    return;
                }
                m.invoke(closable, EMPTY_ARGS);
            }
            catch (NoSuchMethodException e) {
                log.warn((Object)"The closable object does not have a close() method", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn((Object)"Cannot access close() method on closable object", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    log.error((Object)"The close() method threw a runtime exception", t);
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    log.error((Object)"The close() method threw an error", t);
                    throw (Error)t;
                }
                if (t instanceof Exception) {
                    log.error((Object)"The close() method threw an exception", t);
                }
                log.error((Object)"The close() method threw an unexpected throwable", t);
            }
        }
    }

    public static void safeClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing outstream", (Throwable)e);
            }
        }
    }

    public static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing inputstream", (Throwable)e);
            }
        }
    }

    public static void safeClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing reader", (Throwable)e);
            }
        }
    }

    public static void safeClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing writer", (Throwable)e);
            }
        }
    }

    public static BufferedInputStream safeBufferedWrapper(InputStream in) {
        if (in != null) {
            if (in instanceof BufferedInputStream) {
                return (BufferedInputStream)in;
            }
            return new BufferedInputStream(in);
        }
        return null;
    }

    public static BufferedOutputStream safeBufferedWrapper(OutputStream out) {
        if (out != null) {
            if (out instanceof BufferedOutputStream) {
                return (BufferedOutputStream)out;
            }
            return new BufferedOutputStream(out);
        }
        return null;
    }
}

