/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.impl.generic.server;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.test.framework.impl.generic.agent.GenericTestAgent;
import org.jboss.portal.test.framework.impl.generic.config.NodeConfig;
import org.jboss.portal.test.framework.impl.generic.config.ServerConfig;
import org.jboss.portal.test.framework.impl.generic.config.ServiceConfig;
import org.jboss.portal.test.framework.impl.generic.server.GenericNode;
import org.jboss.portal.test.framework.impl.generic.server.GenericRemoteServiceLookup;
import org.jboss.portal.test.framework.impl.generic.server.GenericServiceLookup;
import org.jboss.portal.test.framework.server.Node;
import org.jboss.portal.test.framework.server.NodeId;

public class GenericNodeFactory {
    private final URL serverConfigURL;
    private String serverName;
    private final Map nodes;

    public GenericNodeFactory(String serverConfigLocation, String serverName) {
        if (serverConfigLocation == null) {
            throw new IllegalArgumentException("No null servers.xml location accepted");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("No null server name accepted");
        }
        URL serverConfigURL = Thread.currentThread().getContextClassLoader().getResource(serverConfigLocation);
        if (serverConfigURL == null) {
            throw new IllegalArgumentException("No invalid servers.xml location=" + serverConfigLocation + " accepted");
        }
        this.serverName = serverName;
        this.serverConfigURL = serverConfigURL;
        this.nodes = new HashMap();
    }

    public String getServerName() {
        return this.serverName;
    }

    public URL getServerConfigURL() {
        return this.serverConfigURL;
    }

    public void start() throws Exception {
        Map cfgs = ServerConfig.createConfigs(this.serverConfigURL);
        ServerConfig serverCfg = (ServerConfig)cfgs.get(this.serverName);
        if (serverCfg == null) {
            throw new IllegalStateException("Cannot start the node factory because the config for the server " + this.serverName + " has not been found");
        }
        for (NodeConfig nodeCfg : serverCfg.getNodes().values()) {
            HashMap<String, GenericServiceLookup> serviceLookupMap = new HashMap<String, GenericServiceLookup>();
            for (ServiceConfig serviceCfg : nodeCfg.getServices().values()) {
                GenericRemoteServiceLookup serviceLookup = new GenericRemoteServiceLookup(serviceCfg.getURI(), serviceCfg.getInterfaceClass());
                serviceLookupMap.put(serviceCfg.getName(), serviceLookup);
            }
            GenericTestAgent testAgent = new GenericTestAgent();
            testAgent.setAuthenticationConfig(nodeCfg.getAuthentication());
            testAgent.setDeployerConfig(nodeCfg.getDeployer());
            serviceLookupMap.put("TestAgent", testAgent);
            GenericNode node = new GenericNode(nodeCfg.getId(), serviceLookupMap);
            this.nodes.put(node.getId(), node);
        }
    }

    public Node getNode(String nodeId) {
        return (Node)this.nodes.get(new NodeId(nodeId));
    }
}

