/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.impl.generic.config;

import java.io.BufferedInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.test.framework.common.io.IOTools;
import org.jboss.portal.test.framework.common.xml.XMLTools;
import org.jboss.portal.test.framework.impl.generic.config.AuthenticationConfig;
import org.jboss.portal.test.framework.impl.generic.config.NodeConfig;
import org.jboss.portal.test.framework.impl.generic.config.RemoteDeployerConfig;
import org.jboss.portal.test.framework.impl.generic.config.ServiceConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerConfig {
    private final String name;
    private final Map nodes;

    public ServerConfig(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException();
        }
        this.name = serverName;
        this.nodes = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void addNode(NodeConfig node) {
        this.nodes.put(node.getId(), node);
    }

    public Map getNodes() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map createConfigs(URL url) throws Exception {
        LinkedHashMap<String, ServerConfig> configs = new LinkedHashMap<String, ServerConfig>();
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper(url.openStream());
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
            Iterator<Element> i = XMLTools.getChildrenIterator(doc.getDocumentElement(), "server");
            while (i.hasNext()) {
                Element serverElt = i.next();
                ServerConfig serverCfg = ServerConfig.createConfig(serverElt);
                configs.put(serverCfg.getName(), serverCfg);
            }
            LinkedHashMap<String, ServerConfig> linkedHashMap = configs;
            return linkedHashMap;
        }
        finally {
            IOTools.safeClose(in);
        }
    }

    public static ServerConfig createConfig(Element serverElt) {
        Element serverNameElt = XMLTools.getUniqueChild(serverElt, "server-name", true);
        ServerConfig serverCfg = new ServerConfig(XMLTools.asString(serverNameElt));
        List<Element> nodeElts = XMLTools.getChildren(serverElt, "node");
        for (Element nodeElt : nodeElts) {
            Element nodeIdElt = XMLTools.getUniqueChild(nodeElt, "node-id", true);
            List<Element> serviceElts = XMLTools.getChildren(nodeElt, "service");
            Element deployerElt = XMLTools.getUniqueChild(nodeElt, "deployer", true);
            NodeConfig node = new NodeConfig(XMLTools.asString(nodeIdElt));
            for (Element serviceElt : serviceElts) {
                Element serviceNameElt = XMLTools.getUniqueChild(serviceElt, "service-name", true);
                Element interfaceElt = XMLTools.getUniqueChild(serviceElt, "interface", true);
                Element uriElt = XMLTools.getUniqueChild(serviceElt, "uri", true);
                ServiceConfig service = new ServiceConfig(XMLTools.asString(serviceNameElt));
                service.setInterfaceClass(XMLTools.asString(interfaceElt));
                service.setURI(XMLTools.asString(uriElt));
                node.addService(service);
            }
            Element remoteElt = XMLTools.getUniqueChild(deployerElt, "remote", true);
            Element authenticationElt = XMLTools.getUniqueChild(deployerElt, "authentication", false);
            Element remoteNameElt = XMLTools.getUniqueChild(remoteElt, "name", true);
            Element remoteHostElt = XMLTools.getUniqueChild(remoteElt, "host", true);
            Element remotePortElt = XMLTools.getUniqueChild(remoteElt, "port", true);
            RemoteDeployerConfig cargoCfg = new RemoteDeployerConfig();
            cargoCfg.setName(XMLTools.asString(remoteNameElt));
            cargoCfg.setHost(XMLTools.asString(remoteHostElt));
            cargoCfg.setPort(XMLTools.asString(remotePortElt));
            node.setDeployer(cargoCfg);
            if (authenticationElt != null) {
                Element authenticationUsernameElt = XMLTools.getUniqueChild(authenticationElt, "username", true);
                Element authenticationPasswordElt = XMLTools.getUniqueChild(authenticationElt, "password", true);
                AuthenticationConfig authenticationCfg = new AuthenticationConfig();
                authenticationCfg.setUsername(XMLTools.asString(authenticationUsernameElt));
                authenticationCfg.setPassword(XMLTools.asString(authenticationPasswordElt));
                node.setAuthentication(authenticationCfg);
            }
            serverCfg.addNode(node);
        }
        return serverCfg;
    }
}

