/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.SharedObjectFacade;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractWeldAnnotated<T, S>
implements WeldAnnotated<T, S> {
    private static final Set<Annotation> DEFAULT_QUALIFIERS = Collections.singleton(DefaultLiteral.INSTANCE);
    private final Map<Class<? extends Annotation>, Annotation> annotationMap;
    private final ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap;
    private final Class<T> rawType;
    private final Type[] actualTypeArguments;
    private final Type type;
    private final LazyValueHolder<Set<Type>> typeClosure;

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Annotation[] annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static Map<Class<? extends Annotation>, Annotation> buildAnnotationMap(Iterable<Annotation> annotations) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static void addMetaAnnotations(ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Annotation[] metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractWeldAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    protected static void addMetaAnnotations(ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Iterable<Annotation> metaAnnotations, boolean declared) {
        for (Annotation metaAnnotation : metaAnnotations) {
            AbstractWeldAnnotated.addMetaAnnotation(metaAnnotationMap, annotation, metaAnnotation.annotationType(), declared);
        }
    }

    private static void addMetaAnnotation(ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap, Annotation annotation, Class<? extends Annotation> metaAnnotationType, boolean declared) {
        if (declared ? MAPPED_DECLARED_METAANNOTATIONS.contains(metaAnnotationType) : MAPPED_METAANNOTATIONS.contains(metaAnnotationType)) {
            metaAnnotationMap.putSingleElement(metaAnnotationType, annotation);
        }
    }

    public AbstractWeldAnnotated(Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer, Class<T> rawType, Type type, LazyValueHolder<Set<Type>> typeClosure) {
        if (annotationMap == null) {
            throw new WeldException(ReflectionMessage.ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.annotationMap = SharedObjectFacade.wrap(annotationMap);
        if (!annotationMap.isEmpty()) {
            ArraySetMultimap<Class<? extends Annotation>, Annotation> metaAnnotationMap = new ArraySetMultimap<Class<? extends Annotation>, Annotation>();
            for (Annotation annotation : annotationMap.values()) {
                AbstractWeldAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, annotation.annotationType().getAnnotations(), false);
                AbstractWeldAnnotated.addMetaAnnotations(metaAnnotationMap, annotation, classTransformer.getTypeStore().get(annotation.annotationType()), false);
            }
            metaAnnotationMap.trimToSize();
            this.metaAnnotationMap = metaAnnotationMap;
        } else {
            this.metaAnnotationMap = null;
        }
        if (declaredAnnotationMap == null) {
            throw new WeldException(ReflectionMessage.DECLARED_ANNOTATION_MAP_NULL, new Object[0]);
        }
        this.rawType = rawType;
        this.type = type;
        this.actualTypeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : new Type[0];
        this.typeClosure = typeClosure;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays2.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
    }

    @Override
    public Set<Type> getInterfaceClosure() {
        HashSet<Type> interfaces = new HashSet<Type>();
        for (Type t : this.getTypeClosure()) {
            if (!Reflections.getRawType(t).isInterface()) continue;
            interfaces.add(t);
        }
        return Collections.unmodifiableSet(interfaces);
    }

    public abstract S getDelegate();

    @Override
    public boolean isParameterizedType() {
        return this.rawType.getTypeParameters().length > 0;
    }

    @Override
    public boolean isPrimitive() {
        return this.getJavaClass().isPrimitive();
    }

    @Override
    public Type getBaseType() {
        return this.type;
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.typeClosure.get();
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(new ArraySet<Annotation>(this.annotationMap.values()));
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        if (this.metaAnnotationMap == null) {
            return Collections.emptySet();
        }
        Object annotations = this.metaAnnotationMap.get(metaAnnotationType);
        if (annotations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new ArraySet(annotations));
    }

    @Override
    @Deprecated
    public Set<Annotation> getQualifiers() {
        if (this.getMetaAnnotations(Qualifier.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(Qualifier.class));
        }
        return Collections.unmodifiableSet(DEFAULT_QUALIFIERS);
    }

    @Override
    @Deprecated
    public Annotation[] getBindingsAsArray() {
        return this.getQualifiers().toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }
}

