/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.interceptor.InterceptorBindingType;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.Enabled;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.HashSetSupplier;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class Beans {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);

    public static boolean isPassivatingScope(Bean<?> bean, BeanManagerImpl manager) {
        if (bean == null) {
            return false;
        }
        if (bean instanceof SessionBean) {
            return ((SessionBean)bean).getEjbDescriptor().isStateful();
        }
        return manager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isPassivating();
    }

    public static boolean isPassivationCapableBean(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableBean();
        }
        return Reflections.isSerializable(bean.getBeanClass());
    }

    public static boolean isPassivationCapableDependency(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableDependency();
        }
        if (Beans.isNormalScoped(bean)) {
            return true;
        }
        return bean.getScope().equals(Dependent.class) && Beans.isPassivationCapableBean(bean);
    }

    public static boolean isNormalScoped(Bean<?> bean) {
        return Container.instance().services().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal();
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static List<Set<FieldInjectionPoint<?, ?>>> getFieldInjectionPoints(Bean<?> declaringBean, WeldClass<?> weldClass) {
        if (weldClass.isModified()) {
            return Beans.getFieldInjectionPointsFromWeldFields(declaringBean, weldClass);
        }
        return Beans.getFieldInjectionPointsFromDeclaredFields(declaringBean, weldClass);
    }

    private static List<Set<FieldInjectionPoint<?, ?>>> getFieldInjectionPointsFromWeldFields(Bean<?> declaringBean, WeldClass<?> weldClass) {
        Collection<WeldField<?, ?>> allFields = weldClass.getWeldFields(Inject.class);
        ArrayList injectableFields = new ArrayList();
        for (Class clazz = weldClass.getJavaClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ArraySet set = new ArraySet();
            for (WeldField<?, ?> field : allFields) {
                Class<?> declaringClass = ((Field)field.getJavaMember()).getDeclaringClass();
                if (!declaringClass.equals(clazz)) continue;
                Beans.addFieldInjectionPoint(declaringBean, weldClass, field, set);
            }
            set.trimToSize();
            injectableFields.add(0, set);
        }
        return injectableFields;
    }

    private static List<Set<FieldInjectionPoint<?, ?>>> getFieldInjectionPointsFromDeclaredFields(Bean<?> declaringBean, WeldClass<?> weldClass) {
        ArrayList list = new ArrayList();
        for (WeldClass<?> c = weldClass; c != null && !c.getJavaClass().equals(Object.class); c = c.getWeldSuperclass()) {
            ArraySet injectionPoints = new ArraySet();
            for (WeldField<?, ?> field : c.getDeclaredWeldFields(Inject.class)) {
                Beans.addFieldInjectionPoint(declaringBean, weldClass, field, injectionPoints);
            }
            injectionPoints.trimToSize();
            list.add(0, injectionPoints);
        }
        return list;
    }

    private static void addFieldInjectionPoint(Bean<?> declaringBean, WeldClass<?> weldClass, WeldField<?, ?> field, Set<FieldInjectionPoint<?, ?>> injectionPoints) {
        if (Beans.isInjectableField(field)) {
            Beans.validateInjectableField(field);
            injectionPoints.add(FieldInjectionPoint.of(declaringBean, weldClass, field));
        }
    }

    private static boolean isInjectableField(WeldField<?, ?> field) {
        return !field.isStatic() && !field.isAnnotationPresent(Produces.class);
    }

    private static void validateInjectableField(WeldField<?, ?> field) {
        if (field.isFinal()) {
            throw new DefinitionException(UtilMessage.QUALIFIER_ON_FINAL_FIELD, field);
        }
    }

    public static Set<FieldInjectionPoint<?, ?>> mergeFieldInjectionPoints(List<? extends Set<? extends FieldInjectionPoint<?, ?>>> fieldInjectionPoints) {
        ArraySet injectionPoints = new ArraySet();
        for (Set<FieldInjectionPoint<?, ?>> set : fieldInjectionPoints) {
            injectionPoints.addAll(set);
        }
        return injectionPoints.trimToSize();
    }

    public static <T> List<WeldMethod<?, ? super T>> getPostConstructMethods(WeldClass<T> type) {
        WeldClass<T> t = type;
        ArrayList methods = new ArrayList();
        while (!t.getJavaClass().equals(Object.class)) {
            Collection<WeldMethod<?, T>> declaredMethods = Beans.filterOutOverriddenMethods(type, (Collection)Reflections.cast(t.getDeclaredWeldMethods(PostConstruct.class)));
            log.trace(BeanMessage.FOUND_POST_CONSTRUCT_METHODS, declaredMethods, type);
            if (declaredMethods.size() > 1) {
                throw new DefinitionException(UtilMessage.TOO_MANY_POST_CONSTRUCT_METHODS, type);
            }
            if (declaredMethods.size() == 1) {
                WeldMethod<?, T> method = declaredMethods.iterator().next();
                log.trace(BeanMessage.FOUND_ONE_POST_CONSTRUCT_METHOD, method, type);
                methods.add(0, method);
            }
            t = t.getWeldSuperclass();
        }
        return methods;
    }

    private static <T> Collection<WeldMethod<?, ? super T>> filterOutOverriddenMethods(WeldClass<T> type, Collection<WeldMethod<?, ? super T>> methods) {
        ArrayList notOverriddenMethods = new ArrayList();
        for (WeldMethod<?, T> weldMethod : methods) {
            if (type.isMethodOverridden(weldMethod)) continue;
            notOverriddenMethods.add(weldMethod);
        }
        return Collections.unmodifiableCollection(notOverriddenMethods);
    }

    public static <T> List<WeldMethod<?, ? super T>> getObserverMethods(WeldClass<T> type) {
        ArrayList observerMethods = new ArrayList();
        SetMultimap<MethodSignature, Package> seenMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Package>>(){

            @Override
            public Set<Package> get() {
                return new HashSet<Package>();
            }
        });
        for (WeldClass<T> t = type; t != null && !t.getJavaClass().equals(Object.class); t = t.getWeldSuperclass()) {
            for (WeldMethod<?, T> method : t.getDeclaredWeldMethods()) {
                if (!Beans.isOverridden(method, seenMethods) && !method.getWeldParameters(Observes.class).isEmpty()) {
                    observerMethods.add(method);
                }
                seenMethods.put(method.getSignature(), method.getPackage());
            }
        }
        return observerMethods;
    }

    public static <T> List<WeldMethod<?, ? super T>> getPreDestroyMethods(WeldClass<T> type) {
        WeldClass<T> t = type;
        ArrayList methods = new ArrayList();
        while (!t.getJavaClass().equals(Object.class)) {
            Collection<WeldMethod<?, T>> declaredMethods = Beans.filterOutOverriddenMethods(type, (Collection)Reflections.cast(t.getDeclaredWeldMethods(PreDestroy.class)));
            log.trace(BeanMessage.FOUND_PRE_DESTROY_METHODS, declaredMethods, type);
            if (declaredMethods.size() > 1) {
                throw new DefinitionException(UtilMessage.TOO_MANY_PRE_DESTROY_METHODS, type);
            }
            if (declaredMethods.size() == 1) {
                WeldMethod<?, T> method = declaredMethods.iterator().next();
                log.trace(BeanMessage.FOUND_ONE_PRE_DESTROY_METHOD, method, type);
                methods.add(0, method);
            }
            t = t.getWeldSuperclass();
        }
        return methods;
    }

    public static List<WeldMethod<?, ?>> getInterceptableMethods(WeldClass<?> type) {
        ArrayList annotatedMethods = new ArrayList();
        for (WeldMethod<?, ?> annotatedMethod : type.getWeldMethods()) {
            boolean businessMethod = !annotatedMethod.isStatic() && !annotatedMethod.isAnnotationPresent(Inject.class) && !((Method)annotatedMethod.getJavaMember()).isBridge();
            if (!businessMethod || Beans.isInterceptorMethod(annotatedMethod)) continue;
            annotatedMethods.add(annotatedMethod);
        }
        return annotatedMethods;
    }

    private static boolean isInterceptorMethod(WeldMethod<?, ?> annotatedMethod) {
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (!annotatedMethod.isAnnotationPresent(InterceptionTypeRegistry.getAnnotationClass(interceptionType))) continue;
            return true;
        }
        return false;
    }

    public static Set<WeldInjectionPoint<?, ?>> getEjbInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(EjbInjectionServices.class)) {
            Class<? extends Annotation> ejbAnnotationType = manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS;
            return Beans.getInjectionPoints(declaringBean, type, ejbAnnotationType);
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getPersistenceContextInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            Class<? extends Annotation> persistenceContextAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            return Beans.getInjectionPoints(declaringBean, type, persistenceContextAnnotationType);
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getPersistenceUnitInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            Class<? extends Annotation> persistenceUnitAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_UNIT_ANNOTATION_CLASS;
            return Beans.getInjectionPoints(declaringBean, type, persistenceUnitAnnotationType);
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getResourceInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(ResourceInjectionServices.class)) {
            Class<? extends Annotation> resourceAnnotationType = manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS;
            return Beans.getInjectionPoints(declaringBean, type, resourceAnnotationType);
        }
        return Collections.emptySet();
    }

    private static Set<WeldInjectionPoint<?, ?>> getInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, Class<? extends Annotation> annotationType) {
        ArraySet set = new ArraySet();
        for (WeldField<?, ?> field : type.getWeldFields(annotationType)) {
            set.add(FieldInjectionPoint.of(declaringBean, type, field));
        }
        return set.trimToSize();
    }

    public static List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods(Bean<?> declaringBean, WeldClass<?> weldClass) {
        if (weldClass.isModified()) {
            return Beans.getInitializerMethodsFromWeldMethods(declaringBean, weldClass);
        }
        return Beans.getInitializerMethodsFromDeclaredMethods(declaringBean, weldClass);
    }

    private static <T> List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethodsFromWeldMethods(Bean<?> declaringBean, WeldClass<T> weldClass) {
        ArrayList initializerMethods = new ArrayList();
        SetMultimap<MethodSignature, Package> seenMethods = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (Class clazz = weldClass.getJavaClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ArraySet set = new ArraySet();
            for (WeldMethod<?, T> weldMethod : weldClass.getWeldMethods()) {
                if (!((Method)weldMethod.getJavaMember()).getDeclaringClass().equals(clazz)) continue;
                Beans.processPossibleInitializerMethod(declaringBean, weldClass, weldMethod, seenMethods, set);
            }
            set.trimToSize();
            initializerMethods.add(0, set);
        }
        return initializerMethods;
    }

    public static List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethodsFromDeclaredMethods(Bean<?> declaringBean, WeldClass<?> weldClass) {
        ArrayList list = new ArrayList();
        SetMultimap<MethodSignature, Package> seenMethods = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (WeldClass<?> clazz = weldClass; clazz != null && !clazz.getJavaClass().equals(Object.class); clazz = clazz.getWeldSuperclass()) {
            ArraySet set = new ArraySet();
            Collection<WeldMethod<?, ?>> declaredWeldMethods = clazz.getDeclaredWeldMethods();
            for (WeldMethod<?, ?> method : declaredWeldMethods) {
                Beans.processPossibleInitializerMethod(declaringBean, weldClass, method, seenMethods, set);
            }
            set.trimToSize();
            list.add(0, set);
        }
        return list;
    }

    private static void processPossibleInitializerMethod(Bean<?> declaringBean, WeldClass<?> injectionTargetClass, WeldMethod<?, ?> method, Multimap<MethodSignature, Package> seenMethods, ArraySet<MethodInjectionPoint<?, ?>> set) {
        if (Beans.isInitializerMethod(method)) {
            Beans.validateInitializerMethod(method, injectionTargetClass);
            if (!Beans.isOverridden(method, seenMethods)) {
                set.add(MethodInjectionPoint.of(declaringBean, method));
            }
        }
        seenMethods.put(method.getSignature(), method.getPackage());
    }

    private static boolean isInitializerMethod(WeldMethod<?, ?> method) {
        return method.isAnnotationPresent(Inject.class) && !method.isStatic();
    }

    private static void validateInitializerMethod(WeldMethod<?, ?> method, WeldClass<?> type) {
        if (method.getAnnotation(Produces.class) != null) {
            throw new DefinitionException(UtilMessage.INITIALIZER_CANNOT_BE_PRODUCER, method, type);
        }
        if (method.getWeldParameters(Disposes.class).size() > 0) {
            throw new DefinitionException(UtilMessage.INITIALIZER_CANNOT_BE_DISPOSAL_METHOD, method, type);
        }
        if (method.getWeldParameters(Observes.class).size() > 0) {
            throw new DefinitionException(EventMessage.INVALID_INITIALIZER, method);
        }
        if (method.isGeneric()) {
            throw new DefinitionException(UtilMessage.INITIALIZER_METHOD_IS_GENERIC, method, type);
        }
    }

    private static boolean isOverridden(WeldMethod<?, ?> method, Multimap<MethodSignature, Package> seenMethods) {
        if (method.isPrivate()) {
            return false;
        }
        if (method.isPackagePrivate() && seenMethods.containsKey(method.getSignature())) {
            return seenMethods.get(method.getSignature()).contains(method.getPackage());
        }
        return seenMethods.containsKey(method.getSignature());
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, WeldConstructor<?> constructor) {
        ArraySet injectionPoints = new ArraySet();
        for (WeldParameter parameter : constructor.getWeldParameters()) {
            injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
        }
        return injectionPoints.trimToSize();
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, MethodInjectionPoint<?, ?> method) {
        ArraySet injectionPoints = new ArraySet();
        for (ParameterInjectionPoint<?, ?> parameter : method.getWeldParameters()) {
            if (parameter.isAnnotationPresent(Disposes.class)) continue;
            injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
        }
        return injectionPoints.trimToSize();
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, List<Set<MethodInjectionPoint<?, ?>>> methodInjectionPoints) {
        ArraySet injectionPoints = new ArraySet();
        for (Set<MethodInjectionPoint<?, ?>> i : methodInjectionPoints) {
            for (MethodInjectionPoint<?, ?> method : i) {
                for (ParameterInjectionPoint<?, ?> parameter : method.getWeldParameters()) {
                    injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
                }
            }
        }
        return injectionPoints.trimToSize();
    }

    public static boolean containsAllQualifiers(Set<QualifierInstance> requiredQualifiers, Set<QualifierInstance> qualifiers, BeanManagerImpl beanManager) {
        return qualifiers.containsAll(requiredQualifiers);
    }

    public static boolean containsAllInterceptionBindings(Set<Annotation> expectedBindings, Set<QualifierInstance> existingBindings, BeanManagerImpl manager) {
        Set<QualifierInstance> expected = manager.extractInterceptorBindingsForQualifierInstance(QualifierInstance.qualifiers(manager, expectedBindings));
        return manager.extractInterceptorBindingsForQualifierInstance(existingBindings).containsAll(expected);
    }

    public static boolean findInterceptorBindingConflicts(Set<InterceptorBindingType> flattenedBindings) {
        HashMap<Class<? extends Annotation>, InterceptorBindingType> foundAnnotations = new HashMap<Class<? extends Annotation>, InterceptorBindingType>();
        for (InterceptorBindingType binding : flattenedBindings) {
            if (foundAnnotations.containsKey(binding.annotationType())) {
                if (binding.equals(foundAnnotations.get(binding.annotationType()))) continue;
                return true;
            }
            foundAnnotations.put(binding.annotationType(), binding);
        }
        return false;
    }

    public static <T extends Bean<?>> Set<T> removeDisabledAndSpecializedBeans(Set<T> beans, BeanManagerImpl beanManager) {
        if (beans.size() == 0) {
            return beans;
        }
        HashSet<Bean> result = new HashSet<Bean>();
        for (Bean bean : beans) {
            if (!Beans.isBeanEnabled(bean, beanManager.getEnabled()) || Beans.isSpecialized(bean, beans, beanManager) || Beans.isSuppressedBySpecialization(bean, beanManager)) continue;
            result.add(bean);
        }
        return result;
    }

    public static boolean isBeanEnabled(Bean<?> bean, Enabled enabled) {
        if (bean.isAlternative()) {
            if (enabled.getAlternativeClass(bean.getBeanClass()) != null) {
                return true;
            }
            for (Class<Annotation> stereotype : bean.getStereotypes()) {
                if (enabled.getAlternativeStereotype(stereotype) == null) continue;
                return true;
            }
            return false;
        }
        if (bean instanceof AbstractReceiverBean) {
            AbstractReceiverBean receiverBean = (AbstractReceiverBean)bean;
            return Beans.isBeanEnabled(receiverBean.getDeclaringBean(), enabled);
        }
        if (bean instanceof DecoratorImpl) {
            return enabled.getDecorator(bean.getBeanClass()) != null;
        }
        if (bean instanceof InterceptorImpl) {
            return enabled.getInterceptor(bean.getBeanClass()) != null;
        }
        return true;
    }

    public static boolean isAlternativePresent(Set<Bean<?>> beans) {
        for (Bean<?> bean : beans) {
            if (!bean.isAlternative()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlternative(WeldAnnotated<?, ?> annotated, MergedStereotypes<?, ?> mergedStereotypes) {
        return annotated.isAnnotationPresent(Alternative.class) || mergedStereotypes.isAlternative();
    }

    public static <T extends Bean<?>> boolean isSpecialized(T bean, BeanManagerImpl beanManager) {
        BeansClosure closure = beanManager.getClosure();
        return closure.isSpecialized(bean);
    }

    public static <T extends Bean<?>> boolean isSpecialized(T bean, Set<T> beans, BeanManagerImpl beanManager) {
        BeansClosure closure = beanManager.getClosure();
        Bean<?> specializingBean = closure.getSpecializingBean(bean);
        return specializingBean != null && beans.contains(specializingBean);
    }

    public static boolean isSuppressedBySpecialization(Bean<?> bean, BeanManagerImpl manager) {
        BeansClosure closure;
        return bean instanceof AbstractReceiverBean && (closure = manager.getClosure()).isSpecialized(((AbstractReceiverBean)Reflections.cast(bean)).getDeclaringBean());
    }

    public static <T> ConstructorInjectionPoint<T> getBeanConstructor(Bean<T> declaringBean, WeldClass<T> type) {
        ConstructorInjectionPoint<T> constructor = null;
        Collection<WeldConstructor<T>> initializerAnnotatedConstructors = type.getWeldConstructors(Inject.class);
        log.trace(BeanMessage.FOUND_INJECTABLE_CONSTRUCTORS, initializerAnnotatedConstructors, type);
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException(UtilMessage.AMBIGUOUS_CONSTRUCTOR, type, initializerAnnotatedConstructors);
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            constructor = ConstructorInjectionPoint.of(declaringBean, initializerAnnotatedConstructors.iterator().next());
            log.trace(BeanMessage.FOUND_ONE_INJECTABLE_CONSTRUCTOR, constructor, type);
        } else if (type.getNoArgsWeldConstructor() != null) {
            constructor = ConstructorInjectionPoint.of(declaringBean, type.getNoArgsWeldConstructor());
            log.trace(BeanMessage.FOUND_DEFAULT_CONSTRUCTOR, constructor, type);
        }
        if (constructor == null) {
            throw new DefinitionException(UtilMessage.UNABLE_TO_FIND_CONSTRUCTOR, type);
        }
        return constructor;
    }

    public static <T> void injectEEFields(T beanInstance, BeanManagerImpl manager, Iterable<WeldInjectionPoint<?, ?>> ejbInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> resourceInjectionPoints) {
        EjbInjectionServices ejbServices = manager.getServices().get(EjbInjectionServices.class);
        JpaInjectionServices jpaServices = manager.getServices().get(JpaInjectionServices.class);
        ResourceInjectionServices resourceServices = manager.getServices().get(ResourceInjectionServices.class);
        if (ejbServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : ejbInjectionPoints) {
                Object ejbInstance = ejbServices.resolveEjb(injectionPoint);
                injectionPoint.inject(beanInstance, ejbInstance);
            }
        }
        if (jpaServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : persistenceContextInjectionPoints) {
                EntityManager pcInstance = jpaServices.resolvePersistenceContext(injectionPoint);
                injectionPoint.inject(beanInstance, pcInstance);
            }
            for (WeldInjectionPoint<?, ?> injectionPoint : persistenceUnitInjectionPoints) {
                EntityManagerFactory puInstance = jpaServices.resolvePersistenceUnit(injectionPoint);
                injectionPoint.inject(beanInstance, puInstance);
            }
        }
        if (resourceServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : resourceInjectionPoints) {
                Object resourceInstance = resourceServices.resolveResource(injectionPoint);
                injectionPoint.inject(beanInstance, resourceInstance);
            }
        }
    }

    public static Object resolveEEResource(BeanManagerImpl manager, WeldInjectionPoint<?, ?> injectionPoint) {
        Class<? extends Annotation> resourceAnnotationType;
        Class<? extends Annotation> ejbAnnotationType;
        EjbInjectionServices ejbServices = manager.getServices().get(EjbInjectionServices.class);
        JpaInjectionServices jpaServices = manager.getServices().get(JpaInjectionServices.class);
        ResourceInjectionServices resourceServices = manager.getServices().get(ResourceInjectionServices.class);
        if (ejbServices != null && injectionPoint.isAnnotationPresent(ejbAnnotationType = manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS)) {
            return ejbServices.resolveEjb(injectionPoint);
        }
        if (jpaServices != null) {
            PersistenceApiAbstraction persistenceApiAbstraction = manager.getServices().get(PersistenceApiAbstraction.class);
            Class<? extends Annotation> persistenceUnitAnnotationType = persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS;
            if (injectionPoint.isAnnotationPresent(persistenceUnitAnnotationType)) {
                return jpaServices.resolvePersistenceUnit(injectionPoint);
            }
            Class<? extends Annotation> persistenceContextAnnotationType = persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            if (injectionPoint.isAnnotationPresent(persistenceContextAnnotationType)) {
                return jpaServices.resolvePersistenceContext(injectionPoint);
            }
        }
        if (resourceServices != null && injectionPoint.isAnnotationPresent(resourceAnnotationType = manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS)) {
            return resourceServices.resolveResource(injectionPoint);
        }
        return null;
    }

    public static Type getDeclaredBeanType(Class<?> clazz) {
        Type[] actualTypeArguments = Reflections.getActualTypeArguments(clazz);
        if (actualTypeArguments.length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    public static <T> void injectBoundFields(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends FieldInjectionPoint<?, ?>> injectableFields) {
        for (FieldInjectionPoint<T, T> fieldInjectionPoint : injectableFields) {
            fieldInjectionPoint.inject(instance, manager, creationalContext);
        }
    }

    public static <T> void injectFieldsAndInitializers(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager, List<? extends Iterable<? extends FieldInjectionPoint<?, ?>>> injectableFields, List<? extends Iterable<? extends MethodInjectionPoint<?, ?>>> initializerMethods) {
        if (injectableFields.size() != initializerMethods.size()) {
            throw new IllegalArgumentException(UtilMessage.INVALID_QUANTITY_INJECTABLE_FIELDS_AND_INITIALIZER_METHODS, injectableFields, initializerMethods);
        }
        for (int i = 0; i < injectableFields.size(); ++i) {
            Beans.injectBoundFields(instance, ctx, beanManager, injectableFields.get(i));
            Beans.callInitializers(instance, ctx, beanManager, initializerMethods.get(i));
        }
    }

    public static <T> void callInitializers(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends MethodInjectionPoint<?, ?>> initializerMethods) {
        for (MethodInjectionPoint<T, T> methodInjectionPoint : initializerMethods) {
            methodInjectionPoint.invoke(instance, manager, creationalContext, CreationException.class);
        }
    }

    public static <T> boolean isInterceptor(WeldClass<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Interceptor.class);
    }

    public static <T> boolean isDecorator(WeldClass<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(javax.decorator.Decorator.class);
    }

    public static Annotation[] mergeInQualifiers(Annotation[] qualifiers, Annotation[] newQualifiers) {
        if (qualifiers == null || newQualifiers == null) {
            return Reflections.EMPTY_ANNOTATIONS;
        }
        return Beans.mergeInQualifiers(Arrays.asList(qualifiers), newQualifiers).toArray(Reflections.EMPTY_ANNOTATIONS);
    }

    public static Set<Annotation> mergeInQualifiers(Collection<Annotation> qualifiers, Annotation[] newQualifiers) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            result.addAll(qualifiers);
        }
        if (newQualifiers != null && newQualifiers.length > 0) {
            MetaAnnotationStore store = Container.instance().services().get(MetaAnnotationStore.class);
            HashSet<Annotation> checkedNewQualifiers = new HashSet<Annotation>();
            for (Annotation qualifier : newQualifiers) {
                if (!store.getBindingTypeModel(qualifier.annotationType()).isValid()) {
                    throw new IllegalArgumentException(UtilMessage.ANNOTATION_NOT_QUALIFIER, qualifier);
                }
                if (checkedNewQualifiers.contains(qualifier)) {
                    throw new IllegalArgumentException(UtilMessage.REDUNDANT_QUALIFIER, qualifier, Arrays.asList(newQualifiers));
                }
                checkedNewQualifiers.add(qualifier);
            }
            result.addAll(checkedNewQualifiers);
        }
        return result;
    }

    public static InjectionPoint getDelegateInjectionPoint(Decorator<?> decorator) {
        if (decorator instanceof DecoratorImpl) {
            return ((DecoratorImpl)decorator).getDelegateInjectionPoint();
        }
        for (InjectionPoint injectionPoint : decorator.getInjectionPoints()) {
            if (!injectionPoint.isDelegate()) continue;
            return injectionPoint;
        }
        return null;
    }
}

