/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.jetty.AbstractJettyContainer;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.manager.api.WeldManager;

public class JettyPost72Container
extends AbstractJettyContainer {
    public static Container INSTANCE = new JettyPost72Container();

    @Override
    protected String classToCheck() {
        throw new IllegalAccessError("Should not be used!");
    }

    @Override
    public boolean touch(ContainerContext context) throws Exception {
        int minor;
        ServletContext sc = context.getContext();
        String si = sc.getServerInfo();
        int p = si.indexOf("/");
        if (p < 0) {
            return false;
        }
        String version = si.substring(p + 1);
        String[] split = version.split("\\.");
        int major = Integer.parseInt(split[0]);
        return 100 * major + 10 * (minor = Integer.parseInt(split[1])) >= 720;
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            Class clazz = Reflections.classForName(JettyWeldInjector.class.getName());
            Object injector = clazz.getConstructor(WeldManager.class).newInstance(context.getManager());
            context.getContext().setAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector", injector);
            Class decoratorClass = Reflections.classForName("org.jboss.weld.environment.jetty.WeldDecorator");
            Method processMethod = decoratorClass.getMethod("process", ServletContext.class);
            processMethod.invoke(null, context.getContext());
            this.log.info("Jetty7 detected, JSR-299 injection will be available in Listeners, Servlets and Filters.");
        }
        catch (Exception e) {
            this.log.error("Unable to create JettyWeldInjector. CDI injection will not be available in Servlets, Filters or Listeners", e);
        }
    }
}

