/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.ClassAvailableActivation;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.SystemPropertyActivation;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ClassAvailableActivationImpl;
import org.jboss.weld.metadata.FilterImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.metadata.SystemPropertyActivationImpl;
import org.jboss.weld.xml.XmlMetadata;
import org.slf4j.cal10n.LocLogger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansXmlHandler
extends DefaultHandler {
    static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    public static final String WELD_URI = "http://jboss.org/schema/weld/beans";
    public static final String JAVAEE_URI = "http://java.sun.com/xml/ns/javaee";
    private final Collection<Container> containers;
    private final List<Metadata<String>> interceptors;
    private final List<Metadata<String>> decorators;
    private final List<Metadata<String>> alternativeClasses;
    private final List<Metadata<String>> alternativeStereotypes;
    private final List<Metadata<Filter>> includes;
    private final List<Metadata<Filter>> excludes;
    private final URL file;
    private Collection<Container> seenContainers;
    private Container currentContainer;
    private StringBuilder buffer;
    private Locator locator;

    public BeansXmlHandler(final URL file) {
        this.file = file;
        this.interceptors = new ArrayList<Metadata<String>>();
        this.decorators = new ArrayList<Metadata<String>>();
        this.alternativeClasses = new ArrayList<Metadata<String>>();
        this.alternativeStereotypes = new ArrayList<Metadata<String>>();
        this.includes = new ArrayList<Metadata<Filter>>();
        this.excludes = new ArrayList<Metadata<Filter>>();
        this.seenContainers = new ArrayList<Container>();
        this.containers = new ArrayList<Container>();
        this.containers.add(new Container(JAVAEE_URI, "interceptors", new String[]{"class"}){

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isInNamespace(uri) && "class".equals(localName)) {
                    BeansXmlHandler.this.interceptors.add(new XmlMetadata<String>(qName, 1.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                }
            }

            @Override
            public void handleMultiple() {
                throw new DefinitionException(XmlMessage.MULTIPLE_INTERCEPTORS, file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
        this.containers.add(new Container(JAVAEE_URI, "decorators", new String[]{"class"}){

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isInNamespace(uri) && "class".equals(localName)) {
                    BeansXmlHandler.this.decorators.add(new XmlMetadata<String>(qName, 2.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                }
            }

            @Override
            public void handleMultiple() {
                throw new DefinitionException(XmlMessage.MULTIPLE_DECORATORS, file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
        this.containers.add(new Container(JAVAEE_URI, "alternatives", new String[]{"class", "stereotype"}){

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isInNamespace(uri) && "class".equals(localName)) {
                    BeansXmlHandler.this.alternativeClasses.add(new XmlMetadata<String>(qName, 3.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                } else if (this.isInNamespace(uri) && "stereotype".equals(localName)) {
                    BeansXmlHandler.this.alternativeStereotypes.add(new XmlMetadata<String>(qName, 3.trim(nestedText), file, BeansXmlHandler.this.locator.getLineNumber()));
                }
            }

            @Override
            public void handleMultiple() {
                throw new DefinitionException(XmlMessage.MULTIPLE_ALTERNATIVES, file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
        this.containers.add(new Container(WELD_URI, "scan", new String[0]){
            String name;
            String pattern;
            Collection<Metadata<SystemPropertyActivation>> systemPropertyActivations;
            Collection<Metadata<ClassAvailableActivation>> classAvailableActivations;

            @Override
            public void processStartChildElement(String uri, String localName, String qName, Attributes attributes) {
                if (this.isFilterElement(uri, localName)) {
                    this.name = 4.trim(attributes.getValue("name"));
                    this.pattern = 4.trim(attributes.getValue("pattern"));
                    this.systemPropertyActivations = new ArrayList<Metadata<SystemPropertyActivation>>();
                    this.classAvailableActivations = new ArrayList<Metadata<ClassAvailableActivation>>();
                } else if (this.isInNamespace(uri) && "if-system-property".equals(localName)) {
                    String systemPropertyName = 4.trim(attributes.getValue("name"));
                    String systemPropertyValue = 4.trim(attributes.getValue("value"));
                    XmlMetadata<SystemPropertyActivationImpl> systemPropertyActivation = new XmlMetadata<SystemPropertyActivationImpl>(qName, new SystemPropertyActivationImpl(systemPropertyName, systemPropertyValue), file, BeansXmlHandler.this.locator.getLineNumber());
                    this.systemPropertyActivations.add(systemPropertyActivation);
                } else if (this.isInNamespace(uri) && "if-class-available".equals(localName)) {
                    String className = 4.trim(attributes.getValue("name"));
                    XmlMetadata<ClassAvailableActivationImpl> classAvailableActivation = new XmlMetadata<ClassAvailableActivationImpl>(qName, new ClassAvailableActivationImpl(className), file, BeansXmlHandler.this.locator.getLineNumber());
                    this.classAvailableActivations.add(classAvailableActivation);
                }
            }

            @Override
            public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
                if (this.isFilterElement(uri, localName)) {
                    XmlMetadata<FilterImpl> filter = new XmlMetadata<FilterImpl>(qName, new FilterImpl(this.pattern, this.name, this.systemPropertyActivations, this.classAvailableActivations), file, BeansXmlHandler.this.locator.getLineNumber());
                    if ("include".equals(localName)) {
                        BeansXmlHandler.this.includes.add(filter);
                    } else if ("exclude".equals(localName)) {
                        BeansXmlHandler.this.excludes.add(filter);
                    }
                    this.name = null;
                    this.pattern = null;
                    this.systemPropertyActivations = null;
                    this.classAvailableActivations = null;
                }
            }

            private boolean isFilterElement(String uri, String localName) {
                return this.isInNamespace(uri) && ("include".equals(localName) || "exclude".equals(localName));
            }

            @Override
            public void handleMultiple() {
                throw new DefinitionException(XmlMessage.MULTIPLE_SCANNING, file + "@" + BeansXmlHandler.this.locator.getLineNumber());
            }
        });
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentContainer == null) {
            Container container = this.getContainer(uri, localName);
            if (container != null) {
                if (this.seenContainers.contains(container)) {
                    container.handleMultiple();
                }
                this.currentContainer = container;
            }
        } else {
            this.currentContainer.processStartChildElement(uri, localName, qName, attributes);
            if (this.currentContainer.getNestedElements().contains(localName)) {
                this.buffer = new StringBuilder();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentContainer != null) {
            Container container;
            this.currentContainer.processEndChildElement(uri, localName, qName, this.buffer != null ? this.buffer.toString() : null);
            if (this.currentContainer.getNestedElements().contains(localName)) {
                this.buffer = null;
            }
            if ((container = this.getContainer(uri, localName)) != null) {
                this.seenContainers.add(container);
                this.currentContainer = null;
            }
        }
    }

    private Container getContainer(String uri, String localName) {
        return BeansXmlHandler.getContainer(uri, localName, this.containers);
    }

    private static Container getContainer(String uri, String localName, Collection<Container> containers) {
        for (Container container : containers) {
            if (!(uri.length() == 0 ? container.getLocalName().equals(localName) : container.getLocalName().equals(localName) && container.getUri().equals(uri))) continue;
            return container;
        }
        return null;
    }

    public BeansXml createBeansXml() {
        return new BeansXmlImpl(this.alternativeClasses, this.alternativeStereotypes, this.decorators, this.interceptors, new ScanningImpl(this.includes, this.excludes));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        log.warn(XmlMessage.XSD_VALIDATION_WARNING, this.file, e.getLineNumber(), e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (e.getMessage().equals("cvc-elt.1: Cannot find the declaration of element 'beans'.")) {
            return;
        }
        log.warn(XmlMessage.XSD_VALIDATION_ERROR, this.file, e.getLineNumber(), e.getMessage());
    }

    public static abstract class Container {
        private final String uri;
        private final String localName;
        private final Collection<String> nestedElements;

        public Container(String uri, String localName, String ... nestedElements) {
            this.uri = uri;
            this.localName = localName;
            this.nestedElements = Arrays.asList(nestedElements);
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getUri() {
            return this.uri;
        }

        public void processStartChildElement(String uri, String localName, String qName, Attributes attributes) {
        }

        public void processEndChildElement(String uri, String localName, String qName, String nestedText) {
        }

        public void handleMultiple() {
        }

        public Collection<String> getNestedElements() {
            return this.nestedElements;
        }

        public String toString() {
            return "<" + this.localName + " />";
        }

        protected boolean isInNamespace(String uri) {
            return uri.length() == 0 || uri.equals(this.getUri());
        }

        protected static String trim(String str) {
            if (str == null) {
                return null;
            }
            return str.trim();
        }
    }
}

