/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;

public class EnterpriseBeanProxyMethodHandler<T>
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 2107723373882153667L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final SessionObjectReference reference;
    private final Class<?> objectInterface;
    private final Collection<MethodSignature> removeMethodSignatures;
    private final boolean clientCanCallRemoveMethods;
    private final boolean stateful;

    public EnterpriseBeanProxyMethodHandler(SessionBean<T> bean, CreationalContext<T> creationalContext) {
        this.objectInterface = bean.getEjbDescriptor().getObjectInterface();
        this.removeMethodSignatures = bean.getEjbDescriptor().getRemoveMethodSignatures();
        this.clientCanCallRemoveMethods = bean.isClientCanCallRemoveMethods();
        this.reference = bean.createReference();
        this.stateful = bean.getEjbDescriptor().isStateful();
        log.trace(BeanMessage.CREATED_SESSION_BEAN_PROXY, bean);
    }

    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        MethodSignatureImpl methodSignature;
        if ("destroy".equals(method.getName()) && Marker.isMarker(0, method, args)) {
            if (this.stateful && !this.reference.isRemoved()) {
                this.reference.remove();
            }
            return null;
        }
        if (!this.clientCanCallRemoveMethods && this.removeMethodSignatures.contains(methodSignature = new MethodSignatureImpl(method))) {
            throw new UnsupportedOperationException(BeanMessage.INVALID_REMOVE_METHOD_INVOCATION, method);
        }
        Class<?> businessInterface = this.getBusinessInterface(method);
        if (this.reference.isRemoved() && this.isToStringMethod(method)) {
            return businessInterface.getName() + " [REMOVED]";
        }
        Object proxiedInstance = this.reference.getBusinessObject(businessInterface);
        try {
            Object returnValue = SecureReflections.invoke(proxiedInstance, method, args);
            log.trace(BeanMessage.CALL_PROXIED_METHOD, method, proxiedInstance, args, returnValue);
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw Exceptions.unwrapIfPossible(e);
        }
    }

    private boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    private Class<?> getBusinessInterface(Method method) {
        Class<?> businessInterface = method.getDeclaringClass();
        if (businessInterface.equals(Object.class)) {
            return this.objectInterface;
        }
        return businessInterface;
    }
}

