/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

public class SimpleInjectionTarget<T>
implements InjectionTarget<T> {
    private final BeanManagerImpl beanManager;
    private final WeldClass<T> type;
    private final ConstructorInjectionPoint<T> constructor;
    private final List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private final List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private final List<WeldMethod<?, ? super T>> postConstructMethods;
    private final List<WeldMethod<?, ? super T>> preDestroyMethods;
    private final Set<InjectionPoint> injectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> ejbInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> resourceInjectionPoints;

    public SimpleInjectionTarget(WeldClass<T> type, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.type = type;
        this.injectionPoints = new HashSet<InjectionPoint>();
        if (type.getJavaClass().isInterface()) {
            throw new DefinitionException(BeanMessage.INJECTION_TARGET_CANNOT_BE_CREATED_FOR_INTERFACE, type);
        }
        ConstructorInjectionPoint<T> constructor = null;
        try {
            constructor = Beans.getBeanConstructor(null, type, beanManager);
            this.injectionPoints.addAll(Beans.getParameterInjectionPoints(null, constructor, beanManager));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.constructor = constructor;
        this.injectableFields = Beans.getFieldInjectionPoints(null, type, beanManager);
        this.injectionPoints.addAll(Beans.mergeFieldInjectionPoints(this.injectableFields));
        this.initializerMethods = Beans.getInitializerMethods(null, type, beanManager);
        this.injectionPoints.addAll(Beans.getParameterInjectionPoints(null, this.initializerMethods, beanManager));
        this.postConstructMethods = Beans.getPostConstructMethods(type);
        this.preDestroyMethods = Beans.getPreDestroyMethods(type);
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(null, type, beanManager);
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(null, type, beanManager);
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(null, type, beanManager);
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(null, type, beanManager);
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        if (this.constructor == null) {
            Beans.getBeanConstructor(null, this.type, this.beanManager);
            throw new IllegalStateException(BeanManagerMessage.MISSING_BEAN_CONSTRUCTOR_FOUND, new Object[0]);
        }
        return this.constructor.newInstance(this.beanManager, ctx);
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.beanManager, this, this.getType(), instance){

            @Override
            public void proceed() {
                Beans.injectEEFields(instance, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.ejbInjectionPoints, SimpleInjectionTarget.this.persistenceContextInjectionPoints, SimpleInjectionTarget.this.persistenceUnitInjectionPoints, SimpleInjectionTarget.this.resourceInjectionPoints);
                Beans.injectFieldsAndInitializers(instance, ctx, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.injectableFields, SimpleInjectionTarget.this.initializerMethods);
            }
        }.run();
    }

    @Override
    public void postConstruct(T instance) {
        for (WeldMethod<?, T> method : this.postConstructMethods) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    @Override
    public void preDestroy(T instance) {
        for (WeldMethod<?, T> method : this.preDestroyMethods) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    @Override
    public void dispose(T instance) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected WeldClass<T> getType() {
        return this.type;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    protected List<Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    protected List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }
}

