/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.weld.bootstrap.spi.ClassAvailableActivation;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.SystemPropertyActivation;
import org.jboss.weld.metadata.Selectors;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPredicate
implements Predicate<String> {
    private final boolean active;
    private final Pattern pattern;
    private final String name;

    public FilterPredicate(Metadata<Filter> filter, ResourceLoader resourceLoader) {
        boolean active = true;
        if (filter.getValue().getClassAvailableActivations() != null) {
            for (Metadata<ClassAvailableActivation> metadata : filter.getValue().getClassAvailableActivations()) {
                if (metadata.getValue() == null) {
                    throw new IllegalStateException("Class available activation metadata not available at " + metadata);
                }
                String className = metadata.getValue().getClassName();
                if (className == null) {
                    throw new IllegalStateException("Must specify class name at " + metadata);
                }
                boolean inverted = FilterPredicate.isInverted(className);
                if (inverted) {
                    className = FilterPredicate.removeInversion(className);
                }
                active = active && FilterPredicate.isClassAvailable(className, resourceLoader, inverted);
            }
        }
        if (filter.getValue().getSystemPropertyActivations() != null) {
            for (Metadata<Object> metadata : filter.getValue().getSystemPropertyActivations()) {
                if (metadata.getValue() == null) {
                    throw new IllegalStateException("System property activation metadata not available at " + metadata);
                }
                String propertyName = ((SystemPropertyActivation)metadata.getValue()).getName();
                String requiredPropertyValue = ((SystemPropertyActivation)metadata.getValue()).getValue();
                if (propertyName == null) {
                    throw new IllegalStateException("Must specify system property name at " + metadata);
                }
                boolean propertyNameInverted = FilterPredicate.isInverted(propertyName);
                if (propertyNameInverted && requiredPropertyValue != null) {
                    throw new IllegalStateException("Cannot invert property name and specify property value at " + metadata);
                }
                if (propertyNameInverted) {
                    propertyName = FilterPredicate.removeInversion(propertyName);
                }
                if (requiredPropertyValue == null) {
                    active = active && FilterPredicate.isNotNull(System.getProperty(propertyName), propertyNameInverted);
                    continue;
                }
                boolean requiredPropertyValueInverted = FilterPredicate.isInverted(requiredPropertyValue);
                if (requiredPropertyValueInverted) {
                    requiredPropertyValue = FilterPredicate.removeInversion(requiredPropertyValue);
                }
                active = active && FilterPredicate.isEqual(requiredPropertyValue, System.getProperty(propertyName), requiredPropertyValueInverted);
            }
        }
        this.active = active;
        if (filter.getValue().getPattern() != null) {
            this.name = null;
            try {
                this.pattern = Pattern.compile(filter.getValue().getPattern());
            }
            catch (PatternSyntaxException e) {
                throw new IllegalStateException("Error parsing pattern at " + filter, e);
            }
        } else if (filter.getValue().getName() != null) {
            this.name = filter.getValue().getName();
            this.pattern = null;
        } else {
            if (filter.getValue().getPattern() != null && filter.getValue().getName() != null) {
                throw new IllegalStateException("Cannot specify both a pattern and a name at " + filter);
            }
            throw new IllegalStateException("Must specify one of a pattern and a name at " + filter);
        }
    }

    @Override
    public boolean apply(String className) {
        if (this.active) {
            if (this.pattern != null) {
                return this.pattern.matcher(className).matches();
            }
            return Selectors.matchPath(this.name, className);
        }
        return false;
    }

    private static boolean isClassAvailable(String className, ResourceLoader resourceLoader, boolean invert) {
        if (invert) {
            return !FilterPredicate.isClassAvailable(className, resourceLoader);
        }
        return FilterPredicate.isClassAvailable(className, resourceLoader);
    }

    private static boolean isClassAvailable(String className, ResourceLoader resourceLoader) {
        try {
            resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e) {
            return false;
        }
        return true;
    }

    private static boolean isNotNull(String string, boolean invert) {
        if (invert) {
            return string == null;
        }
        return string != null;
    }

    private static boolean isEqual(String string1, String string2, boolean invert) {
        if (invert) {
            return !string1.equals(string2);
        }
        return string1.equals(string2);
    }

    private static boolean isInverted(String string) {
        return string.startsWith("!");
    }

    private static String removeInversion(String string) {
        if (!string.startsWith("!")) {
            throw new IllegalStateException("Cannot remove inversion from non-inverted string [" + string + "]");
        }
        return string.substring(1);
    }
}

