/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.DecorableBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Decorators;

public abstract class AbstractDecorableBuiltInBean<T>
extends AbstractBuiltInBean<T>
implements DecorableBean<T> {
    private final CurrentInjectionPoint cip;

    protected AbstractDecorableBuiltInBean(String idSuffix, BeanManagerImpl beanManager, Class<T> type) {
        super(idSuffix, beanManager, type);
        this.cip = beanManager.getServices().get(CurrentInjectionPoint.class);
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint ip = this.getInjectionPoint(this.cip);
        List<Decorator<?>> decorators = this.getDecorators(ip);
        T instance = this.newInstance(ip, creationalContext);
        if (decorators.isEmpty()) {
            return instance;
        }
        return Decorators.getOuterDelegate(this, instance, creationalContext, this.getProxyClass(), this.cip.peek(), this.getBeanManager(), decorators);
    }

    protected abstract T newInstance(InjectionPoint var1, CreationalContext<T> var2);

    protected abstract List<Decorator<?>> getDecorators(InjectionPoint var1);

    protected abstract Class<T> getProxyClass();

    protected InjectionPoint getInjectionPoint(CurrentInjectionPoint cip) {
        return cip.peek();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.getClass();
    }

    @Override
    public List<Decorator<?>> getDecorators() {
        return this.beanManager.resolveDecorators(this.getTypes(), this.getQualifiers());
    }
}

