/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.exceptions;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import org.jboss.weld.exceptions.WeldExceptionMessage;

public class WeldExceptionListMessage
implements WeldExceptionMessage,
Serializable {
    private static final long serialVersionUID = 3445187707771082346L;
    private List<? extends Throwable> causes;
    private String message;

    public WeldExceptionListMessage(List<? extends Throwable> throwables) {
        this.causes = throwables;
    }

    @Override
    public String getAsString() {
        if (this.message == null) {
            this.generateMessage();
        }
        return this.message;
    }

    private void generateMessage() {
        StringWriter writer = new StringWriter();
        PrintWriter messageBuffer = new PrintWriter(writer);
        messageBuffer.print("Exception List with ");
        messageBuffer.print(this.causes.size());
        messageBuffer.print(" exceptions:\n");
        int i = 0;
        for (Throwable throwable : this.causes) {
            messageBuffer.print("Exception ");
            messageBuffer.print(i);
            messageBuffer.print(" :\n");
            throwable.printStackTrace(messageBuffer);
        }
        messageBuffer.flush();
        this.message = writer.toString();
    }
}

