/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.injection.spi.InjectionContext;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class InjectionContextImpl<T>
implements InjectionContext<T> {
    private final BeanManagerImpl beanManager;
    private final InjectionTarget<T> injectionTarget;
    private final AnnotatedType<T> annotatedType;
    private final T target;

    public InjectionContextImpl(BeanManagerImpl beanManager, InjectionTarget<T> injectionTarget, AnnotatedType<T> annotatedType, T target) {
        this.beanManager = beanManager;
        this.injectionTarget = injectionTarget;
        this.annotatedType = annotatedType;
        this.target = target;
    }

    public void run() {
        InjectionServices injectionServices = this.beanManager.getServices().get(InjectionServices.class);
        if (injectionServices != null) {
            injectionServices.aroundInject(this);
        } else {
            this.proceed();
        }
    }

    @Override
    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public T getTarget() {
        return this.target;
    }
}

