/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPointImpl;
import org.jboss.weld.injection.ResourceInjectionPoint;
import org.jboss.weld.injection.attributes.FieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.InferingFieldInjectionPointAttributes;
import org.jboss.weld.injection.attributes.InferingParameterInjectionPointAttributes;
import org.jboss.weld.injection.attributes.ParameterInjectionPointAttributes;
import org.jboss.weld.injection.attributes.SpecialParameterInjectionPoint;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.util.ApiAbstraction;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.ws.WSApiAbstraction;

public class InjectionPointFactory {
    private static final InjectionPointFactory INSTANCE = new InjectionPointFactory();
    private static final InjectionPointFactory SILENT_INSTANCE = new InjectionPointFactory(){

        @Override
        protected <T, X> FieldInjectionPointAttributes<T, X> processInjectionPoint(FieldInjectionPointAttributes<T, X> injectionPointAttributes, Class<?> declaringComponentClass, BeanManagerImpl manager) {
            return injectionPointAttributes;
        }

        @Override
        protected <T, X> ParameterInjectionPointAttributes<T, X> processInjectionPoint(ParameterInjectionPointAttributes<T, X> injectionPointAttributes, Class<?> declaringComponentClass, BeanManagerImpl manager) {
            return injectionPointAttributes;
        }
    };

    private InjectionPointFactory() {
    }

    public static InjectionPointFactory instance() {
        return INSTANCE;
    }

    public static InjectionPointFactory silentInstance() {
        return SILENT_INSTANCE;
    }

    protected <T, X> FieldInjectionPointAttributes<T, X> processInjectionPoint(FieldInjectionPointAttributes<T, X> injectionPointAttributes, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        return manager.getContainerLifecycleEvents().fireProcessInjectionPoint(injectionPointAttributes, declaringComponentClass, manager);
    }

    protected <T, X> ParameterInjectionPointAttributes<T, X> processInjectionPoint(ParameterInjectionPointAttributes<T, X> injectionPointAttributes, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        return manager.getContainerLifecycleEvents().fireProcessInjectionPoint(injectionPointAttributes, declaringComponentClass, manager);
    }

    public <T, X> FieldInjectionPoint<T, X> createFieldInjectionPoint(EnhancedAnnotatedField<T, X> field, Bean<?> declaringBean, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        FieldInjectionPointAttributes<T, X> attributes = InferingFieldInjectionPointAttributes.of(field, declaringBean, declaringComponentClass, manager);
        attributes = this.processInjectionPoint(attributes, declaringComponentClass, manager);
        return new FieldInjectionPoint<T, X>(attributes);
    }

    public <T, X> ParameterInjectionPoint<T, X> createParameterInjectionPoint(EnhancedAnnotatedParameter<T, X> parameter, Bean<?> declaringBean, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        ParameterInjectionPointAttributes<T, X> attributes = InferingParameterInjectionPointAttributes.of(parameter, declaringBean, declaringComponentClass, manager);
        attributes = this.processInjectionPoint(attributes, declaringComponentClass, manager);
        return new ParameterInjectionPointImpl<T, X>(attributes);
    }

    public <T> ConstructorInjectionPoint<T> createConstructorInjectionPoint(Bean<T> declaringBean, EnhancedAnnotatedType<T> type, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> constructor = Beans.getBeanConstructor(type);
        return this.createConstructorInjectionPoint(declaringBean, type.getJavaClass(), constructor, manager);
    }

    public <T> ConstructorInjectionPoint<T> createConstructorInjectionPoint(Bean<T> declaringBean, Class<?> declaringComponentClass, EnhancedAnnotatedConstructor<T> constructor, BeanManagerImpl manager) {
        return new ConstructorInjectionPoint<T>(constructor, declaringBean, declaringComponentClass, this, manager);
    }

    public <T, X> MethodInjectionPoint<T, X> createMethodInjectionPoint(EnhancedAnnotatedMethod<T, X> enhancedMethod, Bean<?> declaringBean, Class<?> declaringComponentClass, boolean observerOrDisposer, BeanManagerImpl manager) {
        return new MethodInjectionPoint<T, X>(enhancedMethod, declaringBean, declaringComponentClass, observerOrDisposer, this, manager);
    }

    public List<Set<FieldInjectionPoint<?, ?>>> getFieldInjectionPoints(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        ArrayList injectableFieldsList = new ArrayList();
        if (type.slim() instanceof UnbackedAnnotatedType) {
            Collection<EnhancedAnnotatedField<?, ?>> allFields = type.getEnhancedFields(Inject.class);
            for (Class clazz = type.getJavaClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                ArraySet fields = new ArraySet();
                for (EnhancedAnnotatedField<?, ?> field : allFields) {
                    if (field.isStatic() || !((Field)field.getJavaMember()).getDeclaringClass().equals(clazz)) continue;
                    this.addFieldInjectionPoint(field, fields, declaringBean, type.getJavaClass(), manager);
                }
                injectableFieldsList.add(0, WeldCollections.immutableSet(fields));
            }
        } else {
            for (EnhancedAnnotatedType<?> t = type; t != null && !t.getJavaClass().equals(Object.class); t = t.getEnhancedSuperclass()) {
                ArraySet fields = new ArraySet();
                for (EnhancedAnnotatedField<?, ?> annotatedField : t.getDeclaredEnhancedFields(Inject.class)) {
                    if (annotatedField.isStatic()) continue;
                    this.addFieldInjectionPoint(annotatedField, fields, declaringBean, t.getJavaClass(), manager);
                }
                injectableFieldsList.add(0, WeldCollections.immutableSet(fields));
            }
        }
        return WeldCollections.immutableList(injectableFieldsList);
    }

    private void addFieldInjectionPoint(EnhancedAnnotatedField<?, ?> annotatedField, Set<FieldInjectionPoint<?, ?>> injectableFields, Bean<?> declaringBean, Class<?> declaringComponentClass, BeanManagerImpl manager) {
        if (annotatedField.isFinal()) {
            throw new DefinitionException(UtilMessage.QUALIFIER_ON_FINAL_FIELD, annotatedField);
        }
        injectableFields.add(this.createFieldInjectionPoint(annotatedField, declaringBean, declaringComponentClass, manager));
    }

    public Set<ResourceInjectionPoint<?, ?>> getEjbInjectionPoints(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        return new ResourceInjectionPointDiscovery<EjbInjectionServices, EJBApiAbstraction>(){

            @Override
            protected ResourceInjectionPoint<?, ?> createResourceInjectionPoint(FieldInjectionPoint<?, ?> ip, EjbInjectionServices specializedInjectionServices, EJBApiAbstraction api) {
                return ResourceInjectionPoint.forEjb(ip, specializedInjectionServices);
            }

            @Override
            protected Class<? extends Annotation> getMarkerAnnotation(EJBApiAbstraction api) {
                return api.EJB_ANNOTATION_CLASS;
            }
        }.proceed(declaringBean, type, manager, (EJBApiAbstraction)((ApiAbstraction)manager.getServices().get(EJBApiAbstraction.class)), manager.getServices().get(EjbInjectionServices.class));
    }

    public Set<ResourceInjectionPoint<?, ?>> getPersistenceContextInjectionPoints(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        return new ResourceInjectionPointDiscovery<JpaInjectionServices, PersistenceApiAbstraction>(){

            @Override
            protected ResourceInjectionPoint<?, ?> createResourceInjectionPoint(FieldInjectionPoint<?, ?> ip, JpaInjectionServices specializedInjectionServices, PersistenceApiAbstraction api) {
                return ResourceInjectionPoint.forPersistenceContext(ip, specializedInjectionServices, api);
            }

            @Override
            protected Class<? extends Annotation> getMarkerAnnotation(PersistenceApiAbstraction api) {
                return api.PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            }
        }.proceed(declaringBean, type, manager, (PersistenceApiAbstraction)((ApiAbstraction)manager.getServices().get(PersistenceApiAbstraction.class)), manager.getServices().get(JpaInjectionServices.class));
    }

    public Set<ResourceInjectionPoint<?, ?>> getPersistenceUnitInjectionPoints(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        return new ResourceInjectionPointDiscovery<JpaInjectionServices, PersistenceApiAbstraction>(){

            @Override
            protected ResourceInjectionPoint<?, ?> createResourceInjectionPoint(FieldInjectionPoint<?, ?> ip, JpaInjectionServices specializedInjectionServices, PersistenceApiAbstraction api) {
                return ResourceInjectionPoint.forPersistenceUnit(ip, specializedInjectionServices, api);
            }

            @Override
            protected Class<? extends Annotation> getMarkerAnnotation(PersistenceApiAbstraction api) {
                return api.PERSISTENCE_UNIT_ANNOTATION_CLASS;
            }
        }.proceed(declaringBean, type, manager, (PersistenceApiAbstraction)((ApiAbstraction)manager.getServices().get(PersistenceApiAbstraction.class)), manager.getServices().get(JpaInjectionServices.class));
    }

    public Set<ResourceInjectionPoint<?, ?>> getResourceInjectionPoints(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        return new ResourceInjectionPointDiscovery<ResourceInjectionServices, EJBApiAbstraction>(){

            @Override
            protected ResourceInjectionPoint<?, ?> createResourceInjectionPoint(FieldInjectionPoint<?, ?> ip, ResourceInjectionServices specializedInjectionServices, EJBApiAbstraction api) {
                return ResourceInjectionPoint.forResource(ip, specializedInjectionServices);
            }

            @Override
            protected Class<? extends Annotation> getMarkerAnnotation(EJBApiAbstraction api) {
                return api.RESOURCE_ANNOTATION_CLASS;
            }
        }.proceed(declaringBean, type, manager, (EJBApiAbstraction)((ApiAbstraction)manager.getServices().get(EJBApiAbstraction.class)), manager.getServices().get(ResourceInjectionServices.class));
    }

    public Set<ResourceInjectionPoint<?, ?>> getWebServiceRefInjectionPoints(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        return new ResourceInjectionPointDiscovery<JaxwsInjectionServices, WSApiAbstraction>(){

            @Override
            protected ResourceInjectionPoint<?, ?> createResourceInjectionPoint(FieldInjectionPoint<?, ?> ip, JaxwsInjectionServices specializedInjectionServices, WSApiAbstraction api) {
                return ResourceInjectionPoint.forWebServiceRef(ip, specializedInjectionServices);
            }

            @Override
            protected Class<? extends Annotation> getMarkerAnnotation(WSApiAbstraction api) {
                return api.WEB_SERVICE_REF_ANNOTATION_CLASS;
            }
        }.proceed(declaringBean, type, manager, (WSApiAbstraction)((ApiAbstraction)manager.getServices().get(WSApiAbstraction.class)), manager.getServices().get(JaxwsInjectionServices.class));
    }

    public <X> List<ParameterInjectionPoint<?, X>> getParameterInjectionPoints(EnhancedAnnotatedCallable<?, X, ?> callable, Bean<?> declaringBean, Class<?> declaringComponentClass, BeanManagerImpl manager, boolean observerOrDisposer) {
        ArrayList parameters = new ArrayList();
        Bean<?> bean = null;
        if (!observerOrDisposer) {
            bean = declaringBean;
        }
        for (EnhancedAnnotatedParameter<?, X> parameter : callable.getEnhancedParameters()) {
            if (this.isSpecialParameter(parameter)) {
                parameters.add(SpecialParameterInjectionPoint.of(parameter, bean, declaringBean.getBeanClass(), manager));
                continue;
            }
            parameters.add(this.createParameterInjectionPoint(parameter, bean, declaringComponentClass, manager));
        }
        return WeldCollections.immutableList(parameters);
    }

    private boolean isSpecialParameter(EnhancedAnnotatedParameter<?, ?> parameter) {
        return parameter.isAnnotationPresent(Disposes.class) || parameter.isAnnotationPresent(Observes.class);
    }

    private abstract class ResourceInjectionPointDiscovery<S extends Service, A extends ApiAbstraction> {
        private ResourceInjectionPointDiscovery() {
        }

        private Set<FieldInjectionPoint<?, ?>> getFieldInjectionPointsWithSpecialAnnotation(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, Class<? extends Annotation> annotationType, BeanManagerImpl manager) {
            ArraySet injectionPoints = new ArraySet();
            for (EnhancedAnnotatedField<?, ?> field : type.getEnhancedFields(annotationType)) {
                injectionPoints.add(InjectionPointFactory.this.createFieldInjectionPoint(field, declaringBean, type.getJavaClass(), manager));
            }
            return WeldCollections.immutableSet(injectionPoints);
        }

        public Set<ResourceInjectionPoint<?, ?>> proceed(Bean<?> bean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager, A api, S specializedInjectionServices) {
            Set<FieldInjectionPoint<?, ?>> fieldInjectionPoints;
            if (api != null && specializedInjectionServices != null && !(fieldInjectionPoints = this.getFieldInjectionPointsWithSpecialAnnotation(bean, type, this.getMarkerAnnotation(api), manager)).isEmpty()) {
                HashSet resourceInjectionPoints = new HashSet(fieldInjectionPoints.size());
                for (FieldInjectionPoint<?, ?> fieldInjectionPoint : fieldInjectionPoints) {
                    resourceInjectionPoints.add(this.createResourceInjectionPoint(fieldInjectionPoint, specializedInjectionServices, api));
                }
                return resourceInjectionPoints;
            }
            return Collections.emptySet();
        }

        protected abstract ResourceInjectionPoint<?, ?> createResourceInjectionPoint(FieldInjectionPoint<?, ?> var1, S var2, A var3);

        protected abstract Class<? extends Annotation> getMarkerAnnotation(A var1);
    }
}

