/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Constructor;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.AroundConstructCallback;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class DefaultInstantiator<T>
extends AbstractInstantiator<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private final ConstructorInjectionPoint<T> constructor;

    public DefaultInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl manager) {
        if (type.getJavaClass().isInterface()) {
            throw new DefinitionException(BeanMessage.INJECTION_TARGET_CANNOT_BE_CREATED_FOR_INTERFACE, type);
        }
        if (type.isAbstract()) {
            log.warn(BeanMessage.INJECTION_TARGET_CREATED_FOR_ABSTRACT_CLASS, type.getJavaClass());
        }
        this.constructor = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, type, manager);
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager, AroundConstructCallback<T> callback) {
        if (Reflections.isAbstract(this.constructor.getMember().getDeclaringClass())) {
            throw new DefinitionException(BeanMessage.INJECTION_TARGET_CREATED_FOR_ABSTRACT_CLASS, this.constructor.getMember().getDeclaringClass());
        }
        return super.newInstance(ctx, manager, callback);
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getConstructor() {
        return this.constructor.getAnnotated().getJavaMember();
    }

    public String toString() {
        return "SimpleInstantiator [constructor=" + this.constructor.getMember() + "]";
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }
}

