/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetInitializationContext;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.ejb.SessionBeanInjectionTarget;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class InjectionTargetFactoryImpl<T>
implements InjectionTargetFactory<T> {
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> type;
    private final InjectionTargetService injectionTargetService;
    private final InjectionServices injectionServices;

    protected InjectionTargetFactoryImpl(AnnotatedType<T> type, BeanManagerImpl manager) {
        this.manager = manager;
        AnnotatedTypeValidator.validateAnnotatedType(type);
        this.type = manager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type, manager.getId());
        this.injectionTargetService = manager.getServices().get(InjectionTargetService.class);
        this.injectionServices = manager.getServices().get(InjectionServices.class);
    }

    @Override
    public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        try {
            BasicInjectionTarget<T> injectionTarget = this.createInjectionTarget(this.type, bean);
            this.injectionTargetService.validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BasicInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean) {
        BeanInjectionTarget injectionTarget = null;
        injectionTarget = bean instanceof javax.enterprise.inject.spi.Decorator || type.isAnnotationPresent(Decorator.class) ? new DecoratorInjectionTarget<T>(type, bean, this.manager) : (bean instanceof SessionBean ? new SessionBeanInjectionTarget<T>(type, (SessionBean)bean, this.manager) : new BeanInjectionTarget<T>(type, bean, this.manager));
        this.injectionTargetService.addInjectionTargetToBeInitialized(new InjectionTargetInitializationContext<T>(type, injectionTarget));
        this.postProcessInjectionTarget(type, injectionTarget);
        return injectionTarget;
    }

    protected InjectionTarget<T> createMessageDrivenInjectionTarget() {
        try {
            BasicInjectionTarget<T> injectionTarget = new BasicInjectionTarget<T>(this.type, null, this.manager);
            this.postProcessInjectionTarget(this.type, injectionTarget);
            this.injectionTargetService.validateProducer(injectionTarget);
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <X> void postProcessInjectionTarget(AnnotatedType<X> type, InjectionTarget<X> injectionTarget) {
        if (this.injectionServices != null) {
            this.injectionServices.registerInjectionTarget(injectionTarget, type);
        }
    }
}

