/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.thinkaurelius.titan.core.Parameter;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanKey;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.FramedGraphFactory;
import com.tinkerpop.frames.modules.Module;
import com.tinkerpop.frames.modules.gremlingroovy.GremlinGroovyModule;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerModule;
import com.tinkerpop.frames.modules.typedgraph.TypedGraphModuleBuilder;
import java.io.File;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.graph.model.meta.DatasourceMeta;
import org.jboss.windup.graph.model.meta.JBossModuleMeta;
import org.jboss.windup.graph.model.meta.JMSMeta;
import org.jboss.windup.graph.model.meta.JarManifest;
import org.jboss.windup.graph.model.meta.MailserverMeta;
import org.jboss.windup.graph.model.meta.SpecificationVersionMeta;
import org.jboss.windup.graph.model.meta.javaclass.EjbEntityFacet;
import org.jboss.windup.graph.model.meta.javaclass.EjbSessionBeanFacet;
import org.jboss.windup.graph.model.meta.javaclass.HibernateEntityFacet;
import org.jboss.windup.graph.model.meta.javaclass.MessageDrivenBeanFacet;
import org.jboss.windup.graph.model.meta.javaclass.SpringBeanFacet;
import org.jboss.windup.graph.model.meta.xml.DoctypeMeta;
import org.jboss.windup.graph.model.meta.xml.EjbConfigurationFacet;
import org.jboss.windup.graph.model.meta.xml.HibernateConfigurationFacet;
import org.jboss.windup.graph.model.meta.xml.MavenFacet;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.jboss.windup.graph.model.meta.xml.SpringConfigurationFacet;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.jboss.windup.graph.model.resource.ArchiveResource;
import org.jboss.windup.graph.model.resource.EarArchive;
import org.jboss.windup.graph.model.resource.FileResource;
import org.jboss.windup.graph.model.resource.JarArchive;
import org.jboss.windup.graph.model.resource.JavaClass;
import org.jboss.windup.graph.model.resource.Resource;
import org.jboss.windup.graph.model.resource.TempArchiveResource;
import org.jboss.windup.graph.model.resource.WarArchive;
import org.jboss.windup.graph.model.resource.XmlResource;

public class GraphContext {
    private TitanGraph graph;
    private BatchGraph<TitanGraph> batch;
    private FramedGraph<TitanGraph> framed;

    public TitanGraph getGraph() {
        return this.graph;
    }

    public BatchGraph<TitanGraph> getBatch() {
        return this.batch;
    }

    public FramedGraph<TitanGraph> getFramed() {
        return this.framed;
    }

    public GraphContext(File diskCache) {
        FileUtils.deleteQuietly((File)diskCache);
        File lucene = new File(diskCache, "graphsearch");
        File berkley = new File(diskCache, "graph");
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("storage.directory", (Object)berkley.getAbsolutePath());
        conf.setProperty("storage.backend", (Object)"berkeleyje");
        conf.setProperty("storage.index.search.backend", (Object)"lucene");
        conf.setProperty("storage.index.search.directory", (Object)lucene.getAbsolutePath());
        conf.setProperty("storage.index.search.client-only", (Object)"false");
        conf.setProperty("storage.index.search.local-mode", (Object)"true");
        String INDEX_NAME = "search";
        this.graph = TitanFactory.open((Configuration)conf);
        TitanKey namespaceURIKey = this.graph.makeKey("namespaceURI").dataType(String.class).indexed(Vertex.class).make();
        TitanKey schemaLocationKey = this.graph.makeKey("schemaLocation").dataType(String.class).indexed(Vertex.class).make();
        TitanKey publicIdKey = this.graph.makeKey("publicId").dataType(String.class).indexed(Vertex.class).make();
        TitanKey rootTagKey = this.graph.makeKey("rootTagName").dataType(String.class).indexed(Vertex.class).make();
        TitanKey systemIdKey = this.graph.makeKey("systemId").dataType(String.class).indexed(Vertex.class).make();
        TitanKey qualifiedNameKey = this.graph.makeKey("qualifiedName").dataType(String.class).indexed(Vertex.class).unique().make();
        TitanKey archiveEntryKey = this.graph.makeKey("archiveEntry").dataType(String.class).indexed("search", Vertex.class, new Parameter[0]).make();
        TitanKey typeKey = this.graph.makeKey("type").dataType(String.class).indexed(Vertex.class).make();
        TitanKey filePath = this.graph.makeKey("filePath").dataType(String.class).indexed(Vertex.class).unique().make();
        TitanKey mavenIdentifier = this.graph.makeKey("mavenIdentifier").dataType(String.class).indexed(Vertex.class).unique().make();
        this.batch = new BatchGraph((TransactionalGraph)this.graph, 1000L);
        FramedGraphFactory factory = new FramedGraphFactory(new Module[]{new JavaHandlerModule(), new TypedGraphModuleBuilder().withClass(ArchiveResource.class).withClass(ArchiveEntryResource.class).withClass(EarArchive.class).withClass(FileResource.class).withClass(JarArchive.class).withClass(JavaClass.class).withClass(Resource.class).withClass(WarArchive.class).withClass(XmlResource.class).withClass(TempArchiveResource.class).withClass(EjbEntityFacet.class).withClass(EjbSessionBeanFacet.class).withClass(HibernateEntityFacet.class).withClass(MessageDrivenBeanFacet.class).withClass(SpringBeanFacet.class).withClass(MavenFacet.class).withClass(EjbConfigurationFacet.class).withClass(SpringConfigurationFacet.class).withClass(HibernateConfigurationFacet.class).withClass(NamespaceMeta.class).withClass(DoctypeMeta.class).withClass(DatasourceMeta.class).withClass(JBossModuleMeta.class).withClass(JMSMeta.class).withClass(MailserverMeta.class).withClass(SpecificationVersionMeta.class).withClass(JarManifest.class).build(), new GremlinGroovyModule()});
        this.framed = factory.create((TransactionalGraph)this.graph);
    }
}

