/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.windup.graph.dao.BaseDao;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveEntryDao
extends BaseDao<ArchiveEntryResource> {
    private static Logger LOG = LoggerFactory.getLogger(ArchiveEntryDao.class);

    public ArchiveEntryDao() {
        super(ArchiveEntryResource.class);
    }

    public Iterable<ArchiveEntryResource> findArchiveEntry(String value) {
        return super.getByProperty("archiveEntry", value);
    }

    public long findArchiveEntryWithExtensionCount(String ... values) {
        GremlinPipeline pipe = new GremlinPipeline();
        return pipe.start(this.findArchiveEntryWithExtension(values)).count();
    }

    public Iterable<ArchiveEntryResource> findArchiveEntryWithExtension(String ... values) {
        String regex;
        if (values.length == 0) {
            return IterablesUtil.emptyIterable();
        }
        if (values.length == 1) {
            regex = ".+\\." + values[0] + "$";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            int i = 0;
            for (String value : values) {
                if (i > 0) {
                    builder.append("|");
                }
                builder.append(value);
                ++i;
            }
            builder.append(")\\b");
            regex = ".+\\." + builder.toString() + "$";
        }
        LOG.debug("Regex: " + regex);
        return this.context.getFramed().query().has("type", (Object)this.typeValue).has("archiveEntry", (Predicate)Text.REGEX, (Object)regex).vertices(this.type);
    }

    public InputStream asInputStream(ArchiveEntryResource entry) throws IOException {
        ZipFile zipFile = new ZipFile(new File(entry.getArchive().getFileResource().getFilePath()));
        ZipEntry zipEntry = zipFile.getEntry(entry.getArchiveEntry());
        InputStream is = zipFile.getInputStream(zipEntry);
        return is;
    }
}

