/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.typedgraph.TypeField;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.dao.exception.NonUniqueResultException;

public class BaseDao<T extends VertexFrame> {
    protected final Class<T> type;
    protected final String typeValue;
    @Inject
    GraphContext context;

    public GraphContext getContext() {
        return this.context;
    }

    public BaseDao(Class<T> type) {
        this.type = type;
        TypeValue typeValue = type.getAnnotation(TypeValue.class);
        if (typeValue == null) {
            throw new IllegalArgumentException("Must contain annotation 'TypeValue'");
        }
        this.typeValue = typeValue.value();
    }

    public void delete(T obj) {
        this.context.getFramed().removeVertex(obj.asVertex());
    }

    public Iterable<T> getByProperty(String key, Object value) {
        return this.context.getFramed().getVertices(key, value, this.type);
    }

    public Iterable<T> findValueMatchingRegex(String key, String ... regex) {
        String regexFinal;
        if (regex.length == 0) {
            return IterablesUtil.emptyIterable();
        }
        if (regex.length == 1) {
            regexFinal = regex[0];
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            int i = 0;
            for (String value : regex) {
                if (i > 0) {
                    builder.append("|");
                }
                builder.append(value);
                ++i;
            }
            builder.append(")\\b");
            regexFinal = builder.toString();
        }
        return this.context.getFramed().query().has("type", (Object)this.typeValue).has(key, (Predicate)Text.REGEX, (Object)regexFinal).vertices(this.type);
    }

    public Iterable<T> hasAllProperties(String[] keys, String[] vals) {
        FramedGraphQuery fgq = this.context.getFramed().query().has("type", (Object)this.typeValue);
        int j = keys.length;
        for (int i = 0; i < j; ++i) {
            String key = keys[i];
            String val = vals[i];
            fgq = fgq.has(key, (Object)val);
        }
        return fgq.vertices(this.type);
    }

    public T create(Object id) {
        return (T)((VertexFrame)this.context.getFramed().addVertex(id, this.type));
    }

    public T create() {
        return (T)((VertexFrame)this.context.getFramed().addVertex(null, this.type));
    }

    public Iterable<T> getAll() {
        return this.context.getFramed().query().has("type", (Object)this.typeValue).vertices(this.type);
    }

    public TitanTransaction newTransaction() {
        return this.context.getGraph().newTransaction();
    }

    public long count(Iterable<?> obj) {
        GremlinPipeline pipe = new GremlinPipeline();
        return pipe.start(obj).count();
    }

    public T getById(Object id) {
        return (T)((VertexFrame)this.context.getFramed().getVertex(id, this.type));
    }

    public T getByUniqueProperty(String property, Object value) throws NonUniqueResultException {
        Iterable<T> results = this.getByProperty(property, value);
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator<T> iter = results.iterator();
        VertexFrame result = (VertexFrame)iter.next();
        if (iter.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)result;
    }

    public T castToType(VertexFrame v) {
        Vertex vertex = v.asVertex();
        TypeValue value = this.type.getAnnotation(TypeValue.class);
        TypeField field = this.type.getAnnotation(TypeField.class);
        String property = "type";
        if (field != null) {
            property = field.value();
        }
        String typeValue = this.type.getName();
        if (value != null) {
            typeValue = value.value();
        }
        vertex.setProperty(property, (Object)typeValue);
        this.context.getGraph().commit();
        return (T)((VertexFrame)this.context.getFramed().frame(vertex, this.type));
    }

    public T castToType(Vertex vertex) {
        return (T)((VertexFrame)this.context.getFramed().frame(vertex, this.type));
    }

    public void commit() {
        this.context.getGraph().commit();
    }
}

