/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.windup.graph.dao.BaseDao;
import org.jboss.windup.graph.model.resource.FileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceDao
extends BaseDao<FileResource> {
    private static final Logger LOG = LoggerFactory.getLogger(FileResourceDao.class);

    public FileResourceDao() {
        super(FileResource.class);
    }

    public FileResource getByFilePath(String filePath) {
        FileResource entry = (FileResource)this.getByUniqueProperty("filePath", filePath);
        if (entry == null) {
            entry = (FileResource)this.create();
            entry.setFilePath(filePath);
            this.context.getGraph().commit();
        }
        return entry;
    }

    public InputStream getPayload(FileResource file) throws IOException {
        String fileName = file.getFilePath();
        FileInputStream fis = new FileInputStream(new File(fileName));
        return fis;
    }

    public Iterable<FileResource> findArchiveEntryWithExtension(String ... values) {
        String regex;
        if (values.length == 0) {
            return IterablesUtil.emptyIterable();
        }
        if (values.length == 1) {
            regex = ".+\\." + values[0] + "$";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            int i = 0;
            for (String value : values) {
                builder.append("|");
                builder.append(value);
                ++i;
            }
            builder.append(")\\b");
            regex = ".+\\." + builder.toString() + "$";
        }
        LOG.debug("Regex: " + regex);
        return this.context.getFramed().query().has("type", (Object)this.typeValue).has("filePath", (Predicate)Text.REGEX, (Object)regex).vertices(this.type);
    }
}

