/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.jar.JarFile;
import org.jboss.windup.graph.dao.BaseDao;
import org.jboss.windup.graph.dao.exception.ArchiveIndexReaderException;
import org.jboss.windup.graph.model.resource.JarArchive;

public class JarArchiveDao
extends BaseDao<JarArchive> {
    public JarArchiveDao() {
        super(JarArchive.class);
    }

    public Iterable<JarArchive> findArchiveByMD5(String value) throws ArchiveIndexReaderException {
        return this.getByProperty("md5Hash", value);
    }

    public Iterable<JarArchive> findArchiveBySHA1(String value) throws ArchiveIndexReaderException {
        return this.getByProperty("sha1Hash", value);
    }

    public Iterable<JarArchive> findArchiveByName(String value) throws ArchiveIndexReaderException {
        return this.getByProperty("archiveName", value);
    }

    public Iterable<JarArchive> findArchiveByQualifiedClassName(String clz) throws ArchiveIndexReaderException {
        return null;
    }

    public JarFile asJarFile(JarArchive archive) throws IOException {
        File file = new File(archive.getFileResource().getFilePath());
        return new JarFile(file);
    }

    public Iterable<JarArchive> findUnusedJars() {
        LinkedList<JarArchive> iterable = new LinkedList<JarArchive>();
        for (JarArchive archive : this.getAll()) {
            if (archive.providesForArchives().iterator().hasNext()) continue;
            iterable.add(archive);
        }
        return iterable;
    }

    public Iterable<JarArchive> findCircularReferences(JarArchive archive) {
        HashSet<JarArchive> results = new HashSet<JarArchive>();
        HashSet<String> set = new HashSet<String>();
        for (JarArchive d : archive.dependsOnArchives()) {
            set.add(d.getFileResource().getFilePath());
        }
        for (JarArchive p : archive.providesForArchives()) {
            if (!set.contains(p.getFileResource().getFilePath())) continue;
            results.add(p);
        }
        return results;
    }
}

