/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.Iterator;
import org.jboss.windup.graph.dao.BaseDao;
import org.jboss.windup.graph.model.resource.JavaClass;

public class JavaClassDao
extends BaseDao<JavaClass> {
    public JavaClassDao() {
        super(JavaClass.class);
    }

    public synchronized JavaClass getJavaClass(String qualifiedName) {
        JavaClass clz = (JavaClass)this.getByUniqueProperty("qualifiedName", qualifiedName);
        if (clz == null) {
            clz = (JavaClass)this.create();
            clz.setQualifiedName(qualifiedName);
        }
        return clz;
    }

    public Iterable<JavaClass> findByJavaPackage(String packageName) {
        return this.getContext().getFramed().query().has("type", (Object)this.typeValue).has("packageName", (Object)packageName).vertices(this.type);
    }

    public Iterable<JavaClass> findByJavaVersion(JavaVersion version) {
        return this.getContext().getFramed().query().has("type", (Object)this.typeValue).has("majorVersion", (Object)version.major).has("minorVersion", (Object)version.minor).vertices(this.type);
    }

    public Iterable<JavaClass> getAllClassNotFound() {
        GremlinPipeline pipeline = new GremlinPipeline((Object)this.context.getGraph().getVertices("type", (Object)this.typeValue)).filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

            public Boolean compute(Vertex argument) {
                if (argument.getEdges(Direction.IN, new String[]{"javaClassFacet"}).iterator().hasNext()) {
                    return false;
                }
                return true;
            }
        });
        return this.context.getFramed().frameVertices((Iterable)pipeline, JavaClass.class);
    }

    public Iterable<JavaClass> getAllDuplicateClasses() {
        GremlinPipeline pipeline = new GremlinPipeline((Object)this.context.getGraph().getVertices("type", (Object)this.typeValue)).filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

            public Boolean compute(Vertex argument) {
                Iterator edges = argument.getEdges(Direction.IN, new String[]{"javaClassFacet"}).iterator();
                if (edges.hasNext()) {
                    edges.next();
                    if (edges.hasNext()) {
                        return true;
                    }
                }
                return false;
            }
        });
        return this.context.getFramed().frameVertices((Iterable)pipeline, JavaClass.class);
    }

    public static enum JavaVersion {
        JAVA_7(7, 0),
        JAVA_6(6, 0),
        JAVA_5(5, 0),
        JAVA_1_4(1, 4),
        JAVA_1_3(1, 3),
        JAVA_1_2(1, 2),
        JAVA_1_1(1, 1);

        final int major;
        final int minor;

        private JavaVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

