/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import java.util.Iterator;
import javax.inject.Singleton;
import org.jboss.windup.graph.dao.BaseDao;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NamespaceDao
extends BaseDao<NamespaceMeta> {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceDao.class);

    public NamespaceDao() {
        super(NamespaceMeta.class);
    }

    public Iterable<NamespaceMeta> findByURI(String namespaceURI) {
        return this.getByProperty("namespaceURI", namespaceURI);
    }

    public Iterable<NamespaceMeta> findByURIs(String ... uriRegex) {
        return super.findValueMatchingRegex("namespaceURI", uriRegex);
    }

    public Iterable<NamespaceMeta> findSchemaLocationRegexMatch(String schemaLocationRegex) {
        return super.findValueMatchingRegex("schemaLocation", schemaLocationRegex);
    }

    public NamespaceMeta createNamespaceSchemaLocation(String namespaceURI, String schemaLocation) {
        Iterable results = this.getContext().getFramed().query().has("type", (Object)this.typeValue).has("namespaceURI", (Object)namespaceURI).has("schemaLocation", (Object)schemaLocation).vertices(this.type);
        Iterator i$ = results.iterator();
        if (i$.hasNext()) {
            NamespaceMeta result = (NamespaceMeta)i$.next();
            return result;
        }
        NamespaceMeta meta = (NamespaceMeta)this.create();
        meta.setSchemaLocation(schemaLocation);
        meta.setURI(namespaceURI);
        return meta;
    }
}

