/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.dao;

import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.LinkedList;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jboss.windup.engine.util.xml.LocationAwareXmlReader;
import org.jboss.windup.graph.dao.ArchiveEntryDao;
import org.jboss.windup.graph.dao.BaseDao;
import org.jboss.windup.graph.dao.NamespaceDao;
import org.jboss.windup.graph.model.meta.xml.NamespaceMeta;
import org.jboss.windup.graph.model.resource.ArchiveEntryResource;
import org.jboss.windup.graph.model.resource.Resource;
import org.jboss.windup.graph.model.resource.XmlResource;
import org.w3c.dom.Document;

public class XmlResourceDao
extends BaseDao<XmlResource> {
    @Inject
    private ArchiveEntryDao archiveEntryDao;
    @Inject
    private NamespaceDao namespaceDao;

    public XmlResourceDao() {
        super(XmlResource.class);
    }

    public Iterable<XmlResource> containsNamespaceURI(String namespaceURI) {
        LinkedList<Iterable<XmlResource>> result = new LinkedList<Iterable<XmlResource>>();
        for (NamespaceMeta resource : this.namespaceDao.findByURI(namespaceURI)) {
            result.add(resource.getXmlResources());
        }
        if (result == null || result.size() == 0) {
            return new LinkedList<XmlResource>();
        }
        return Iterables.concat(result);
    }

    public Iterable<XmlResource> findByRootTag(String rootTagName) {
        return this.getByProperty("rootTagName", rootTagName);
    }

    public Document asDocument(XmlResource resource) throws RuntimeException {
        Resource underlyingResource = resource.getResource();
        if (underlyingResource instanceof ArchiveEntryResource) {
            Document document;
            InputStream is = null;
            try {
                Document parsedDocument;
                is = this.archiveEntryDao.asInputStream((ArchiveEntryResource)underlyingResource);
                document = parsedDocument = LocationAwareXmlReader.readXML((InputStream)is);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Exception reading document.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return document;
        }
        return null;
    }
}

