/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.api.Decompiler;
import org.jboss.windup.decompiler.util.CountClassesFilter;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.decompiler.util.ZipUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class DecompilerTestBase {
    private static final Logger log = Logger.getLogger(DecompilerTestBase.class.getName());
    private File testTempDir;

    protected abstract Decompiler getDecompiler();

    protected abstract boolean isResultValid(DecompilationResult var1);

    @Before
    public void setUp() throws IOException {
        this.testTempDir = new File("target/testTmp");
        FileUtils.deleteQuietly((File)this.testTempDir);
        Files.createDirectory(this.testTempDir.toPath(), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws IOException {
    }

    @Test
    public void testDecompileSingleClass() throws DecompilationException, IOException {
        Decompiler dec = this.getDecompiler();
        File archive = new File("target/TestJars/wicket-core-6.11.0.jar");
        File decompDir = new File(this.testTempDir, "decompiled");
        File unzipDir = new File(this.testTempDir, "unzipped");
        ZipUtil.unzip(archive, unzipDir);
        Path clsFile = Paths.get("org/apache/wicket/ajax/AbstractAjaxResponse.class", new String[0]);
        DecompilationResult res = dec.decompileClassFile(unzipDir, clsFile, decompDir);
        Assert.assertNotNull((String)"Results object was returned.", (Object)res);
        if (!res.getFailures().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed decompilation of " + res.getFailures().size() + " classes: ");
            for (DecompilationFailure dex : res.getFailures()) {
                sb.append("\n    ").append(dex.getMessage());
                Throwable cause = dex.getCause();
                if (cause instanceof NullPointerException) {
                    sb.append(" - NPE at ").append(cause.getStackTrace()[0]);
                    continue;
                }
                sb.append(" - ").append(cause);
            }
            if (!this.isResultValid(res)) {
                Assert.fail((String)sb.toString());
            } else {
                log.severe(sb.toString());
            }
        }
        log.info("Compilation results: " + res.getDecompiledFiles().size() + " succeeded, " + res.getFailures().size() + " failed.");
        File sampleFile = new File(decompDir, "org/apache/wicket/ajax/AbstractAjaxResponse.java");
        Assert.assertTrue((String)("Decompiled class did not exist in: " + sampleFile.getAbsolutePath()), (boolean)sampleFile.exists());
    }

    @Test
    public void testDecompileWicketJar() throws DecompilationException {
        File archive = new File("target/TestJars/wicket-core-6.11.0.jar");
        File decompDir = new File(this.testTempDir, "decompiled");
        Decompiler dec = this.getDecompiler();
        DecompilationResult res = dec.decompileArchive(archive, decompDir, (Filter)new CountClassesFilter(100));
        Assert.assertNotNull((String)"Results object returned", (Object)res);
        if (!res.getFailures().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed decompilation of " + res.getFailures().size() + " classes: ");
            for (DecompilationFailure dex : res.getFailures()) {
                sb.append("\n    ").append(dex.getMessage());
            }
            if (!this.isResultValid(res)) {
                Assert.fail((String)sb.toString());
            } else {
                log.severe(sb.toString());
            }
        }
        log.info("Compilation results: " + res.getDecompiledFiles().size() + " succeeded, " + res.getFailures().size() + " failed.");
        File sampleFile = new File(decompDir, "org/apache/wicket/ajax/AbstractAjaxResponse.java");
        Assert.assertTrue((String)("Decompiled class files exist:\n    " + sampleFile.getAbsolutePath()), (boolean)sampleFile.exists());
    }

    @Test
    @Ignore(value="Not yet working.")
    public void testDecompileWicketJarDirectory() throws DecompilationException, IOException {
        Decompiler dec = this.getDecompiler();
        File archive = new File("target/TestJars/wicket-core-6.11.0.jar");
        File decompDir = new File(this.testTempDir, "decompiled");
        File unzipDir = new File(this.testTempDir, "unzipped");
        ZipUtil.unzipWithFilter(archive, unzipDir, new CountClassesFilter(100));
        DecompilationResult res = dec.decompileDirectory(unzipDir, decompDir);
        Assert.assertNotNull((String)"Results object was returned.", (Object)res);
        if (!res.getFailures().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed decompilation of " + res.getFailures().size() + " classes: ");
            for (DecompilationFailure dex : res.getFailures()) {
                sb.append("\n    ").append(dex.getMessage());
            }
            if (!this.isResultValid(res)) {
                Assert.fail((String)sb.toString());
            } else {
                log.severe(sb.toString());
            }
        }
        log.info("Compilation results: " + res.getDecompiledFiles().size() + " succeeded, " + res.getFailures().size() + " failed.");
        File sampleFile = new File(decompDir, "org/apache/wicket/ajax/AbstractAjaxResponse.java");
        Assert.assertTrue((String)("Decompiled class did not exist in: " + sampleFile.getAbsolutePath()), (boolean)sampleFile.exists());
    }
}

