/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.util;

import java.util.zip.ZipEntry;
import org.jboss.windup.decompiler.util.Filter;

public class ClassNameFilter
implements Filter<ZipEntry> {
    private final String cls;

    public ClassNameFilter(String cls) {
        this.cls = cls.replace('.', '/');
    }

    public Filter.Result decide(ZipEntry what) {
        if (what.isDirectory()) {
            return Filter.Result.REJECT;
        }
        if (!what.getName().startsWith(this.cls)) {
            return Filter.Result.REJECT;
        }
        String end = what.getName().substring(this.cls.length());
        if (end.equals(".class")) {
            return Filter.Result.ACCEPT;
        }
        if (end.charAt(0) == '$' && end.endsWith(".class")) {
            return Filter.Result.ACCEPT;
        }
        return Filter.Result.REJECT;
    }
}

