/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.api.Decompiler;
import org.jboss.windup.decompiler.util.CountClassesFilter;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.decompiler.util.ZipUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DecompilerTestBase {
    protected static final Logger log = Logger.getLogger(DecompilerTestBase.class.getName());
    protected Path testTempDir;

    protected abstract Decompiler getDecompiler();

    protected abstract boolean isResultValid(DecompilationResult var1);

    @Before
    public void setUp() throws IOException {
        this.testTempDir = Paths.get("target", new String[0]).resolve("testTmp");
        FileUtils.deleteQuietly((File)this.testTempDir.toFile());
        Files.createDirectory(this.testTempDir, new FileAttribute[0]);
    }

    @After
    public void tearDown() throws IOException {
    }

    @Test
    public void testDecompileSingleClass() throws DecompilationException, IOException {
        Decompiler dec = this.getDecompiler();
        Path archive = Paths.get("target/TestJars/wicket-core-6.11.0.jar", new String[0]);
        Path decompDir = this.testTempDir.resolve("decompiled");
        Path unzipDir = this.testTempDir.resolve("unzipped");
        ZipUtil.unzip(archive.toFile(), unzipDir.toFile());
        Path clsFile = unzipDir.resolve("org/apache/wicket/ajax/AbstractAjaxResponse.class");
        DecompilationResult res = dec.decompileClassFile(unzipDir, clsFile, decompDir);
        Assert.assertNotNull((String)"Results object was returned.", (Object)res);
        if (!res.getFailures().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed decompilation of " + res.getFailures().size() + " classes: ");
            for (DecompilationFailure e : res.getFailures()) {
                sb.append("\n    ").append(e.getMessage());
                Throwable cause = e.getCause();
                cause.printStackTrace();
                if (cause instanceof NullPointerException) {
                    sb.append(" - NPE at ").append(cause.getStackTrace()[0]);
                    continue;
                }
                sb.append(" - ").append(cause);
            }
            if (!this.isResultValid(res)) {
                Assert.fail((String)sb.toString());
            } else {
                log.severe(sb.toString());
            }
        }
        log.info("Compilation results: " + res.getDecompiledFiles().size() + " succeeded, " + res.getFailures().size() + " failed.");
        Path sampleFile = decompDir.resolve("org").resolve("apache").resolve("wicket").resolve("ajax").resolve("AbstractAjaxResponse.java");
        Assert.assertTrue((String)("Decompiled class did not exist in: " + sampleFile.toString()), (boolean)Files.exists(sampleFile, new LinkOption[0]));
        dec.close();
    }

    @Test
    public void testDecompileWicketJar() throws DecompilationException {
        Path archive = Paths.get("target/TestJars/wicket-core-6.11.0.jar", new String[0]);
        Path decompDir = this.testTempDir.resolve("decompiled");
        Decompiler dec = this.getDecompiler();
        DecompilationResult res = dec.decompileArchive(archive, decompDir, (Filter)new CountClassesFilter(100), new DecompilationListener(){

            public void decompilationProcessComplete() {
            }

            public void decompilationFailed(List<String> inputPath, String message) {
            }

            public void fileDecompiled(List<String> inputPath, String outputPath) {
            }
        });
        Assert.assertNotNull((String)"Results object returned", (Object)res);
        if (!res.getFailures().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed decompilation of " + res.getFailures().size() + " classes: ");
            for (DecompilationFailure dex : res.getFailures()) {
                sb.append("\n    ").append(dex.getMessage());
            }
            if (!this.isResultValid(res)) {
                Assert.fail((String)sb.toString());
            } else {
                log.severe(sb.toString());
            }
        }
        log.info("Compilation results: " + res.getDecompiledFiles().size() + " succeeded, " + res.getFailures().size() + " failed.");
        Path sampleFile = decompDir.resolve("org").resolve("apache").resolve("wicket").resolve("ajax").resolve("AbstractAjaxResponse.java");
        Assert.assertTrue((String)("Decompiled class files exist:\n    " + sampleFile.toString()), (boolean)Files.exists(sampleFile, new LinkOption[0]));
        dec.close();
    }
}

