/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jboss.windup.decompiler.util.Filter;

public class ZipUtil {
    public static void unzip(File inputFile, File outputDir) throws IOException {
        ZipUtil.unzipWithFilter(inputFile, outputDir, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipWithFilter(File inputFile, File outputDir, Filter<ZipEntry> filter) throws IOException {
        try (ZipFile zipFile = new ZipFile(inputFile);){
            Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
            block40: while (entryEnum.hasMoreElements()) {
                File parentDir;
                ZipEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                File destFile = new File(outputDir, entryName);
                if (entry.isDirectory()) continue;
                if (filter != null) {
                    Filter.Result res = filter.decide((Object)entry);
                    switch (res) {
                        case STOP: {
                            return;
                        }
                        case REJECT: {
                            continue block40;
                        }
                    }
                }
                if (!(parentDir = destFile.getParentFile()).isDirectory() && !parentDir.mkdirs()) {
                    throw new RuntimeException("Unable to create directory: " + parentDir.getAbsolutePath());
                }
                try (InputStream zipInputStream = zipFile.getInputStream(entry);
                     FileOutputStream outputStream = new FileOutputStream(destFile);){
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                if (filter == null) continue;
                Filter.Result res = filter.decide((Object)entry);
                switch (res) {
                    case ACCEPT_STOP: {
                        return;
                    }
                }
            }
            return;
        }
    }
}

