/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.procyon;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.CompositeTypeLoader;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.NoRetryMetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.BytecodeLanguage;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.io.PathHelper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.decompiler.api.ClassDecompileRequest;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.decompiler.AbstractDecompiler;
import org.jboss.windup.decompiler.procyon.FileOutputWriter;
import org.jboss.windup.decompiler.procyon.LineNumberFormatter;
import org.jboss.windup.decompiler.procyon.ProcyonConfiguration;
import org.jboss.windup.decompiler.procyon.WindupJarTypeLoader;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.exception.WindupStopException;

public class ProcyonDecompiler
extends AbstractDecompiler {
    private static final Logger log = Logger.getLogger(ProcyonDecompiler.class.getName());
    private final ProcyonConfiguration procyonConf;

    public ProcyonDecompiler() {
        this.procyonConf = new ProcyonConfiguration();
    }

    public ProcyonDecompiler(ProcyonConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null.");
        }
        this.procyonConf = configuration;
    }

    public Logger getLogger() {
        return log;
    }

    public Collection<Callable<File>> getDecompileTasks(final Map<String, List<ClassDecompileRequest>> requestMap, final DecompilationListener listener) {
        ClassDecompileRequest mainRequest;
        final AtomicInteger current = new AtomicInteger(0);
        ArrayList<Callable<File>> tasks = new ArrayList<Callable<File>>();
        final TreeMap<Path, DecompilerSettings> settingsByOutputDirectory = new TreeMap<Path, DecompilerSettings>();
        final TreeMap<Path, LinkedList<MetadataSystem>> metadataSystemCaches = new TreeMap<Path, LinkedList<MetadataSystem>>();
        final TreeMap<Path, AtomicInteger> countByOutputDirectory = new TreeMap<Path, AtomicInteger>();
        for (final Map.Entry<String, List<ClassDecompileRequest>> entry : requestMap.entrySet()) {
            mainRequest = entry.getValue().get(0);
            if (!settingsByOutputDirectory.containsKey(mainRequest.getOutputDirectory())) {
                DecompilerSettings settings = this.getDefaultSettings(mainRequest.getOutputDirectory().toFile());
                CompositeTypeLoader typeLoader = new CompositeTypeLoader(new ITypeLoader[]{new ClasspathTypeLoader(mainRequest.getRootDirectory().toString()), new ClasspathTypeLoader()});
                settings.setTypeLoader((ITypeLoader)typeLoader);
                settingsByOutputDirectory.put(mainRequest.getOutputDirectory(), settings);
                LinkedList<MetadataSystem> metadataSystemCache = new LinkedList<MetadataSystem>();
                this.refreshMetadataCache(metadataSystemCache, settings);
                metadataSystemCaches.put(mainRequest.getOutputDirectory(), metadataSystemCache);
                countByOutputDirectory.put(mainRequest.getOutputDirectory(), new AtomicInteger(1));
                continue;
            }
            ((AtomicInteger)countByOutputDirectory.get(mainRequest.getOutputDirectory())).incrementAndGet();
        }
        for (final Map.Entry<String, List<ClassDecompileRequest>> entry : requestMap.entrySet()) {
            mainRequest = entry.getValue().get(0);
            Callable<File> callable = new Callable<File>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File call() throws Exception {
                    if (listener.isCancelled()) {
                        return null;
                    }
                    List classFilePaths = ProcyonDecompiler.this.pathsFromDecompilationRequests((List)entry.getValue());
                    DecompilerSettings settings = (DecompilerSettings)settingsByOutputDirectory.get(mainRequest.getOutputDirectory());
                    Queue metadataSystemCache = (Queue)metadataSystemCaches.get(mainRequest.getOutputDirectory());
                    MetadataSystem metadataSystem = null;
                    try {
                        Queue queue = metadataSystemCache;
                        synchronized (queue) {
                            if (current.incrementAndGet() % 50 == 0) {
                                log.info("Decompiling " + current + " / " + requestMap.size());
                                ProcyonDecompiler.this.refreshMetadataCache(metadataSystemCache, settings);
                            }
                            metadataSystem = (MetadataSystem)metadataSystemCache.remove();
                        }
                        ExecutionStatistics.get().begin("ProcyonDecompiler.decompileIndividualItem");
                        String typeName = mainRequest.getClassFile().normalize().toAbsolutePath().toString().substring(mainRequest.getRootDirectory().normalize().toAbsolutePath().toString().length() + 1);
                        typeName = StringUtils.removeEnd((String)typeName, (String)".class");
                        DecompileExecutor t = new DecompileExecutor(settings, metadataSystem, typeName);
                        t.start();
                        t.join(60000L);
                        if (!t.success) {
                            if (t.e == null) {
                                t.cancelDecompilation();
                                throw new RuntimeException("Failed to decompile within 60 seconds... attempting abort", t.e);
                            }
                            throw new RuntimeException(t.e);
                        }
                        File outputFile = t.outputFile;
                        if (outputFile != null) {
                            listener.fileDecompiled(classFilePaths, outputFile.getAbsolutePath());
                        }
                        File file = outputFile;
                        return file;
                    }
                    catch (Throwable th) {
                        String msg = "Error during decompilation of " + mainRequest.getClassFile() + ": " + th.getMessage();
                        DecompilationFailure ex = new DecompilationFailure(msg, classFilePaths, th);
                        log.log(Level.SEVERE, msg, ex);
                        listener.decompilationFailed(classFilePaths, msg);
                    }
                    finally {
                        if (metadataSystem != null) {
                            Queue queue = metadataSystemCache;
                            synchronized (queue) {
                                metadataSystemCache.add(metadataSystem);
                            }
                        }
                        if (((AtomicInteger)countByOutputDirectory.get(mainRequest.getOutputDirectory())).decrementAndGet() == 0) {
                            settingsByOutputDirectory.remove(mainRequest.getOutputDirectory());
                            metadataSystemCaches.remove(mainRequest.getOutputDirectory());
                        }
                        ExecutionStatistics.get().end("ProcyonDecompiler.decompileIndividualItem");
                    }
                    return null;
                }
            };
            tasks.add(callable);
        }
        return tasks;
    }

    private List<String> pathsFromDecompilationRequests(List<ClassDecompileRequest> requests) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassDecompileRequest request : requests) {
            result.add(request.getClassFile().toString());
        }
        return result;
    }

    public DecompilationResult decompileClassFile(Path rootDir, Path classFilePath, Path outputDir) throws DecompilationException {
        Checks.checkDirectoryToBeRead((File)rootDir.toFile(), (String)"Classes root dir");
        File classFile = classFilePath.toFile();
        Checks.checkFileToBeRead((File)classFile, (String)"Class file");
        Checks.checkDirectoryToBeFilled((File)outputDir.toFile(), (String)"Output directory");
        log.info("Decompiling .class '" + classFilePath + "' to '" + outputDir + "' from: '" + rootDir + "'");
        String name = classFilePath.normalize().toAbsolutePath().toString().substring(rootDir.toAbsolutePath().toString().length() + 1);
        String typeName = StringUtils.removeEnd((String)name, (String)".class");
        DecompilationResult result = new DecompilationResult();
        try {
            DecompilerSettings settings = this.getDefaultSettings(outputDir.toFile());
            this.procyonConf.setDecompilerSettings(settings);
            CompositeTypeLoader typeLoader = new CompositeTypeLoader(new ITypeLoader[]{new ClasspathTypeLoader(rootDir.toString()), new ClasspathTypeLoader()});
            MetadataSystem metadataSystem = new MetadataSystem((ITypeLoader)typeLoader);
            File outputFile = this.decompileType(settings, metadataSystem, typeName);
            result.addDecompiled(Collections.singletonList(classFilePath.toString()), outputFile.getAbsolutePath());
        }
        catch (Throwable e) {
            DecompilationFailure failure = new DecompilationFailure("Error during decompilation of " + classFilePath.toString() + ":\n    " + e.getMessage(), Collections.singletonList(name), e);
            log.severe(failure.getMessage());
            result.addFailure(failure);
        }
        return result;
    }

    private void decompileDirectory(final Path rootDir, Path outputDir, Path subPath, final DecompilationResult result) throws DecompilationException {
        Checks.checkDirectoryToBeRead((File)rootDir.toFile(), (String)"Directory to decompile");
        Checks.checkDirectoryToBeFilled((File)outputDir.toFile(), (String)"Output directory");
        log.info("Decompiling subdir '" + subPath + "'");
        final DecompilerSettings settings = this.getDefaultSettings(outputDir.toFile());
        File curDirFull = rootDir.resolve(subPath).toFile();
        List<File> files = Arrays.asList(curDirFull.listFiles());
        ArrayList<2> tasks = new ArrayList<2>();
        for (File file : files) {
            final NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem((ITypeLoader)new InputTypeLoader());
            if (file.isDirectory()) {
                Path subPathNew = subPath.resolve(file.getName());
                this.decompileDirectory(rootDir, outputDir, subPathNew, result);
                continue;
            }
            if (!file.getName().endsWith(".class") || file.getName().contains("$")) continue;
            final String fileSubPath = subPath.resolve(file.getName()).toString();
            final String fqcn = StringUtils.removeEnd((String)fileSubPath, (String)".class").replace('/', '.');
            final String fileAbsolutePath = file.getAbsolutePath();
            Callable<File> callable = new Callable<File>(){

                @Override
                public File call() throws Exception {
                    try {
                        File outputFile = ProcyonDecompiler.this.decompileType(settings, metadataSystem, fqcn);
                        if (null == outputFile) {
                            throw new IllegalStateException("Unknown Procyon error, type not found.");
                        }
                        result.addDecompiled(Collections.singletonList(fileAbsolutePath), outputFile.getAbsolutePath());
                        return outputFile;
                    }
                    catch (Exception e) {
                        DecompilationFailure failure = new DecompilationFailure("Error during decompilation of " + rootDir + " / " + fileSubPath + ":\n    " + e.getMessage(), Collections.singletonList(fileSubPath.toString()), (Throwable)e);
                        log.log(Level.SEVERE, failure.getMessage(), failure);
                        result.addFailure(failure);
                        return null;
                    }
                }
            };
            tasks.add(callable);
        }
        try {
            this.getExecutorService().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecompilationResult decompileArchiveImpl(final Path archive, Path outputDir, Filter<ZipEntry> filter, final DecompilationListener listener) throws DecompilationException {
        Checks.checkFileToBeRead((File)archive.toFile(), (String)"Archive to decompile");
        Checks.checkDirectoryToBeFilled((File)outputDir.toFile(), (String)"Output directory");
        log.info("Decompiling archive '" + archive.toAbsolutePath() + "' to '" + outputDir.toAbsolutePath() + "'");
        JarFile jar = this.loadJar(archive.toFile());
        try {
            final AtomicInteger jarEntryCount = new AtomicInteger(0);
            Enumeration<JarEntry> countEnum = jar.entries();
            while (countEnum.hasMoreElements()) {
                countEnum.nextElement();
                jarEntryCount.incrementAndGet();
            }
            final DecompilerSettings settings = this.getDefaultSettings(outputDir.toFile());
            settings.setTypeLoader((ITypeLoader)new CompositeTypeLoader(new ITypeLoader[]{new WindupJarTypeLoader(jar), settings.getTypeLoader()}));
            final DecompilationResult res = new DecompilationResult();
            final AtomicInteger current = new AtomicInteger(0);
            Enumeration<JarEntry> entries = jar.entries();
            ArrayList<3> tasks = new ArrayList<3>();
            final LinkedList<MetadataSystem> metadataSystemCache = new LinkedList<MetadataSystem>();
            this.refreshMetadataCache(metadataSystemCache, settings);
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                final String name = entry.getName();
                if (!name.endsWith(".class")) {
                    jarEntryCount.decrementAndGet();
                    continue;
                }
                if (filter != null) {
                    Filter.Result filterRes = filter.decide((Object)entry);
                    if (filterRes == Filter.Result.REJECT) {
                        jarEntryCount.decrementAndGet();
                        continue;
                    }
                    if (filterRes == Filter.Result.STOP) break;
                }
                final String typeName = StringUtils.removeEnd((String)name, (String)".class");
                Callable<File> callable = new Callable<File>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public File call() throws Exception {
                        MetadataSystem metadataSystem = null;
                        try {
                            Queue queue = metadataSystemCache;
                            synchronized (queue) {
                                if (current.incrementAndGet() % 50 == 0) {
                                    log.info("Decompiling " + current + " / " + jarEntryCount);
                                    ProcyonDecompiler.this.refreshMetadataCache(metadataSystemCache, settings);
                                }
                                metadataSystem = (MetadataSystem)metadataSystemCache.remove();
                            }
                            ExecutionStatistics.get().begin("ProcyonDecompiler.decompileIndividualItem");
                            DecompileExecutor t = new DecompileExecutor(settings, metadataSystem, typeName);
                            t.start();
                            t.join(60000L);
                            if (!t.success) {
                                if (t.e == null) {
                                    t.cancelDecompilation();
                                    throw new RuntimeException("Failed to decompile file within 60 seconds... attempting abort", t.e);
                                }
                                throw new RuntimeException(t.e);
                            }
                            File outputFile = t.outputFile;
                            if (outputFile != null) {
                                listener.fileDecompiled(Collections.singletonList(name), outputFile.getAbsolutePath());
                                res.addDecompiled(Collections.singletonList(name), outputFile.getAbsolutePath());
                            }
                            File file = outputFile;
                            return file;
                        }
                        catch (WindupStopException ex) {
                            String msg = "Detected a request to stop during decompilation of " + archive.toString() + "!" + name + ":\n    " + ex.getMessage();
                            log.log(Level.WARNING, msg + System.lineSeparator() + "     (Rethrowing)");
                            throw new WindupStopException(msg, (Exception)((Object)ex));
                        }
                        catch (Throwable th) {
                            String msg = "Error during decompilation of " + archive.toString() + "!" + name + ":\n    " + th.getMessage();
                            DecompilationFailure ex = new DecompilationFailure(msg, Collections.singletonList(name), th);
                            log.log(Level.SEVERE, msg, ex);
                            res.addFailure(ex);
                        }
                        finally {
                            if (metadataSystem != null) {
                                Queue queue = metadataSystemCache;
                                synchronized (queue) {
                                    metadataSystemCache.add(metadataSystem);
                                }
                            }
                            ExecutionStatistics.get().end("ProcyonDecompiler.decompileIndividualItem");
                        }
                        return null;
                    }
                };
                tasks.add(callable);
            }
            try {
                this.getExecutorService().invokeAll(tasks);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Decompilation was interrupted.");
            }
            finally {
                listener.decompilationProcessComplete();
            }
            DecompilationResult decompilationResult = res;
            return decompilationResult;
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                log.warning("Failed to close jar file: " + jar.getName());
            }
        }
    }

    private void refreshMetadataCache(Queue<MetadataSystem> metadataSystemCache, DecompilerSettings settings) {
        metadataSystemCache.clear();
        for (int i = 0; i < this.getNumberOfThreads(); ++i) {
            metadataSystemCache.add(new NoRetryMetadataSystem(settings.getTypeLoader()));
        }
    }

    private File decompileType(DecompilerSettings settings, MetadataSystem metadataSystem, String typeName) throws IOException {
        boolean nested;
        TypeReference type;
        log.fine("Decompiling " + typeName);
        if (typeName.length() == 1) {
            MetadataParser parser = new MetadataParser(IMetadataResolver.EMPTY);
            TypeReference reference = parser.parseTypeDescriptor(typeName);
            type = metadataSystem.resolve(reference);
        } else {
            type = metadataSystem.lookupType(typeName);
        }
        if (type == null) {
            log.severe("Failed to load class: " + typeName);
            return null;
        }
        TypeDefinition resolvedType = type.resolve();
        if (resolvedType == null) {
            log.severe("Failed to resolve type: " + typeName);
            return null;
        }
        boolean bl = nested = resolvedType.isNested() || resolvedType.isAnonymous() || resolvedType.isSynthetic();
        if (!this.procyonConf.isIncludeNested() && nested) {
            return null;
        }
        settings.setFormattingOptions(new JavaFormattingOptions());
        FileOutputWriter writer = ProcyonDecompiler.createFileWriter(resolvedType, settings);
        PlainTextOutput output = new PlainTextOutput((Writer)writer);
        output.setUnicodeOutputEnabled(settings.isUnicodeOutputEnabled());
        if (settings.getLanguage() instanceof BytecodeLanguage) {
            output.setIndentToken("  ");
        }
        DecompilationOptions options = new DecompilationOptions();
        options.setSettings(settings);
        TypeDecompilationResults results = settings.getLanguage().decompileType(resolvedType, (ITextOutput)output, options);
        writer.flush();
        writer.close();
        List lineNumberPositions = results.getLineNumberPositions();
        if (!this.procyonConf.getLineNumberOptions().isEmpty()) {
            LineNumberFormatter lineFormatter = new LineNumberFormatter(writer.getFile(), lineNumberPositions, this.procyonConf.getLineNumberOptions());
            lineFormatter.reformatFile();
        }
        return writer.getFile();
    }

    private DecompilerSettings getDefaultSettings(File outputDir) {
        DecompilerSettings settings = new DecompilerSettings();
        this.procyonConf.setDecompilerSettings(settings);
        settings.setOutputDirectory(outputDir.getPath());
        settings.setShowSyntheticMembers(false);
        settings.setForceExplicitImports(true);
        if (settings.getTypeLoader() == null) {
            settings.setTypeLoader((ITypeLoader)new ClasspathTypeLoader());
        }
        return settings;
    }

    private JarFile loadJar(File archive) throws DecompilationException {
        try {
            return new JarFile(archive);
        }
        catch (IOException ex) {
            throw new DecompilationException("Can't load .jar: " + archive.getPath(), (Throwable)ex);
        }
    }

    private static synchronized FileOutputWriter createFileWriter(TypeDefinition type, DecompilerSettings settings) throws IOException {
        String outputDirectory = settings.getOutputDirectory();
        String fileName = type.getName() + settings.getLanguage().getFileExtension();
        String packageName = type.getPackageName();
        String subDir = ((String)StringUtils.defaultIfEmpty((CharSequence)packageName, (CharSequence)"")).replace('.', File.separatorChar);
        String outputPath = PathHelper.combine((String)outputDirectory, (String)subDir, (String)fileName);
        File outputFile = new File(outputPath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IllegalStateException("Could not create directory:" + parentDir);
        }
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IllegalStateException("Could not create output file: " + outputPath);
        }
        return new FileOutputWriter(outputFile, settings);
    }

    private class DecompileExecutor
    extends Thread {
        private DecompilerSettings settings;
        private MetadataSystem metadataSystem;
        private String typeName;
        private Exception e;
        private File outputFile;
        private boolean success;

        public DecompileExecutor(DecompilerSettings settings, MetadataSystem metadataSystem, String typeName) {
            this.settings = settings;
            this.metadataSystem = metadataSystem;
            this.typeName = typeName;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.outputFile = ProcyonDecompiler.this.decompileType(this.settings, this.metadataSystem, this.typeName);
                this.success = true;
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        public void cancelDecompilation() {
            this.interrupt();
            for (int i = 0; i < 10; ++i) {
                if (!this.isAlive()) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new WindupException("Interrupted while attempting to abort thread", (Throwable)e);
                }
            }
            if (this.isAlive()) {
                this.stop();
            }
        }
    }
}

